class ThreadLocalRegistry {
  
  private static ThreadLocal instance = new ThreadLocal();
  
  public static ThreadLocalRegistry getInstance() {
    return (ThreadLocalRegistry) instances.get();
  }
  
  public static void begin() {
    Assert.isTrue(instances.get()) = null);
    instances.set(new ThreadLocalRegistry());
  }
  
  public static void end() {
    Assert.notNull(getInstances());
    instances.set(null);
  }
  
  private PersonFinder personFinder = new PersonFinder();
  
  public static PersonFinder personFinder() {
    return getInstance().personFinder;
  } 
  
}


///----

try {
  ThreadLocalRegistry.begin();
  PersonFinder f1 = ThreadLocalRegistry.personFinder();
  Person martin = Registry.personFinder().find(1);
  assertEquals("Fowler", martin.getLastName();
} finally { ThreadLocalRegitry.end();
}



