# Chapter 10: IoT and Networked Sensors
This is a companion repository for _Making Embedded Systems, 2nd Ed._ by Elecia White. 

# Following Along in the Book
**Network systems** administration is tough, especially when it is a minor part of the system you are tasked to build. To get up to speed on how it all works, I like this [Overview of Networks](https://intronetworks.cs.luc.edu/current2/html/intro.html) which is the introduction of a much longer book. If you'd prefer videos, this [Networking Fundamentals](https://www.youtube.com/playlist?list=PLIFyRwBY_4bRLmKfP1KnZA6rZbRHtxmXi) play list is a great place to get started.

As with networks, **BLE** has many books to help you get oriented. 
(FIXME: the page I was going to suggest is v. old)

Creating an **application level communication protocol** is something you'll probably have to do at some point. Check out Memfault's [Event Serialization](https://docs.memfault.com/docs/mcu/event-serialization-overview/) post on the pros and cons of different methods. Wikipedia has a broader [comparison of data serialization formats](https://en.wikipedia.org/wiki/Comparison_of_data-serialization_formats).

**Checksums** can identify errors in communication. While there are many simple checksums, CRCs are a better way to go. The Barr Group has a [deep dive into calculating CRCs](https://barrgroup.com/Embedded-Systems/How-To/CRC-Calculation-C-Code) that includes code and examples. (The CRC series starts [here](https://barrgroup.com/tech-talks/checksums-and-crcs) if you want to see the whole derivation.)

Different networking strategies are described in Elecia’s comic [Consumer Llama and the Internet of Things](https://embedded.fm/blog/llama).

For one in a million problems, [here is a write](https://medium.com/fitbit-tech-blog/the-tower-of-terror-a-bug-mystery-c57f51981eff) up describing tracking down a divide-by-zero issue caused by a roller coaster. 



# Code For This Chapter

SimplifiedBootloaderFlow.svg
BootloaderDiagrams.md

# Final Note
If you like what's here, please consider buying the book: [_Making Embedded Systems, 2nd Ed._](https://learning.oreilly.com/library/view/making-embedded-systems/9781098151539/) by Elecia White
