# Chapter 6: Managing the Flow of Control
This is a companion repository for _Making Embedded Systems, 2nd Ed._ by Elecia White. 

# Following Along in the Book
The [OSDev Wiki](https://wiki.osdev.org/Expanded_Main_Page) is a fantastic resource for learning about operating systems. It is a little easier to start with a question and dig in than to wander that site.  

[FreeRTOS demo list](https://freertos.org/a00090.html) shows MCUs supported by FreeRTOS. Alternatively, check out [Getting Started With Zephyr](https://docs.zephyrproject.org/latest/develop/getting_started/index.html)


[Designing Reusable Classes](https://www.researchgate.net/publication/215446177_Designing_Reusable_Classes) by Ralph Johnson and Brian Foote is a paper from 1988 that is still one of the best references for how to design reusable code (and why).

Miro Samek of Quantum Leaps is an enthusiastic advocate for the active object pattern and good software in embedded systems. His [books and blog](https://www.state-machine.com/kb) are filled with excellent information but his [YouTube channel](https://www.youtube.com/channel/UCMGXFEew8I6gzjg3tWen4Gw) are particularly instructive as he codes the systems as he talks.


State Machine Diagramming Tools
 * [draw.io](https://app.diagrams.net/) make online flowcharts and diagrams ([its code](https://app.diagrams.net/)), no signup
 * [PlantUML.com](https://plantuml.com/) generates many different types of diagrams from a text description. Less control over placement, but ability to check diagram into source control is a strong tradeoff, no signup
 * [State Machine Diagramming](https://online.visual-paradigm.com/diagrams/features/state-machine-diagram-software/)
 * QFSM ([sourceforge](https://sourceforge.net/projects/qfsm/)) and Ragel ([wiki](https://en.wikipedia.org/wiki/Ragel)) which generates code from UML
 * [Sketch.Systems](https://sketch.systems/): Online tool to describe state machines and make them into clickable prototypes.


[Denigma.app](https://denigma.app) is a tool to translate code to “understandable” English


Watchdog
 * [Proper Watchdog Timer Use](https://betterembsw.blogspot.com/2014/05/proper-watchdog-timer-use.html) a blog post by Phil Koopman
 * A comparison of [Internal vs External Watchdog Timers](https://www.maximintegrated.com/en/design/technical-documents/app-notes/4/4229.html) an article by Analog Devices




# Code For This Chapter
FIXME: Active objects in a repo
FIXME: State machine code, stoplight controller
FIXME: Different main loops
FIXME: Generate code from csv


# Final Note
If you like what's here, please consider buying the book: [_Making Embedded Systems, 2nd Ed._](https://learning.oreilly.com/library/view/making-embedded-systems/9781098151539/) by Elecia White
