# Chapter 12: Math
This is a companion repository for _Making Embedded Systems, 2nd Ed._ by Elecia White. 

Math. 

Don't forget python does LaTeX output

# Following Along in the Book

[A great explanation of Fourier Transforms (blog and video)](https://betterexplained.com/articles/an-interactive-guide-to-the-fourier-transform/): Smoothies that go through the Fourier Transform produce recipes. 

For a super awesome resource on signal processing, check out the [DSP Guide](https://dspguide.com/) aka The Scientist and Engineer's Guide to Digital Signal Processing By Steven W. Smith, Ph.D.

**Machine Learning is hard!**
[Deep Learning with Python](https://learning.oreilly.com/library/view/deep-learning-with/9781617296864/)

## Use existing libraries
[Arm Cortex-M CMSIS DSP software library](https://arm-software.github.io/CMSIS_5/DSP/html/index.html) is what you should use if you can. There are statistics, fake floating points, trig, control theory and a bunch of other math features. 

There is also an [Arm Cortex-M CMSIS NN software library](https://arm-software.github.io/CMSIS_5/NN/html/index.html) to support machine learning features. 


# Code For This Chapter
 * [averaging.c](averaging.c) shows different implementations of averaging.
 * [fakefloats.c](fakefloats.c) shows the code from the book regarding fake floating point numbers
 * [Averaging.xlsx](Averaging.xlsx) created the diagrams
 * [determiningError.xlsx](determiningError.xlsx) shows how to determine the error given differently sized floating point numbers


# Final Note
If you like what's here, please consider buying the book: [_Making Embedded Systems, 2nd Ed._](https://learning.oreilly.com/library/view/making-embedded-systems/9781098151539/) by Elecia White
