<?php

/**
 * Skroty form base class.
 *
 * @method Skroty getObject() Returns the current form's model object
 *
 * @package    noth
 * @subpackage form
 * @author     Your name here
 */
abstract class BaseSkrotyForm extends BaseFormPropel
{
  public function setup()
  {
    $this->setWidgets(array(
      'skroty_id' => new sfWidgetFormInputHidden(),
      'tytul'     => new sfWidgetFormInputText(),
      'slug'      => new sfWidgetFormInputText(),
    ));

    $this->setValidators(array(
      'skroty_id' => new sfValidatorChoice(array('choices' => array($this->getObject()->getSkrotyId()), 'empty_value' => $this->getObject()->getSkrotyId(), 'required' => false)),
      'tytul'     => new sfValidatorString(array('max_length' => 128, 'required' => false)),
      'slug'      => new sfValidatorString(array('max_length' => 128, 'required' => false)),
    ));

    $this->validatorSchema->setPostValidator(
      new sfValidatorPropelUnique(array('model' => 'Skroty', 'column' => array('slug')))
    );

    $this->widgetSchema->setNameFormat('skroty[%s]');

    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);

    parent::setup();
  }

  public function getModelName()
  {
    return 'Skroty';
  }


}
