<?php

class propelImportdanychTask extends sfBaseTask
{
  protected function configure()
  {
    // // add your own arguments here
    // $this->addArguments(array(
    //   new sfCommandArgument('my_arg', sfCommandArgument::REQUIRED, 'My argument'),
    // ));

    $this->addOptions(array(
      new sfCommandOption('application', null, sfCommandOption::PARAMETER_REQUIRED, 'The application name'),
      new sfCommandOption('env', null, sfCommandOption::PARAMETER_REQUIRED, 'The environment', 'dev'),
      new sfCommandOption('connection', null, sfCommandOption::PARAMETER_REQUIRED, 'The connection name', 'propel'),
      // add your own options here
    ));

    $this->namespace        = 'propel';
    $this->name             = 'import-danych';
    $this->briefDescription = '';
    $this->detailedDescription = <<<EOF
The [propel:import-danych|INFO] task does things.
Call it with:

  [php symfony propel:import-danych|INFO]
EOF;
  }

  protected function execute($arguments = array(), $options = array())
  {
    // initialize the database connection
    $databaseManager = new sfDatabaseManager($this->configuration);
    $connection = $databaseManager->getDatabase($options['connection'])->getConnection();

    // add your code here


    require_once 'lib/slugs.inc.php';

    ProjektHasCzcionkaPeer::doDeleteAll();
    CzcionkaPeer::doDeleteAll();
    RodzinaPeer::doDeleteAll();
    ProjektPeer::doDeleteAll();
    
    $plk = file('data/czcionki.txt');
    shuffle($plk);
    foreach ($plk as $l) {
        $str_czcionka = trim($l);
        $c = new Criteria();
        $c->add(CzcionkaPeer::NAZWA, $str_czcionka);
        $czcionka = CzcionkaPeer::doSelectOne($c);
        if (!$czcionka) {
            $czcionka = new Czcionka();
            $czcionka->setNazwa($str_czcionka);
            $czcionka->setSlug(string2slug($str_czcionka));
            if (file_exists('web/images/cz/lowercase/' . $slug . '.png')) {
                $czcionka->setPodglad(1);
            } else {
                $czcionka->setPodglad(0);
            }
            $czcionka->save();
        }
    }

    $plk = file('data/rodziny.txt');
    shuffle($plk);
    foreach ($plk as $l) {
        $e = explode('|', trim($l));
        $str_rodzina = $e[0];
        $c = new Criteria();
        $c->add(RodzinaPeer::NAZWA, $str_rodzina);
        $rodzina = RodzinaPeer::doSelectOne($c);
        if (!$rodzina) {
            $rodzina = new Rodzina();
            $rodzina->setNazwa($str_rodzina);
            $rodzina->setSlug(string2slug($str_rodzina));
            $rodzina->save();
        }
        $tmp = explode(',', trim($e[1]));
        foreach ($tmp as $str_czcionka) {
            $str_czcionka = trim($str_czcionka);
            $c = new Criteria();
            $c->add(CzcionkaPeer::NAZWA, $str_czcionka);
            $czcionka = CzcionkaPeer::doSelectOne($c);
            if ($czcionka) {
               $czcionka->setRodzina($rodzina);
               $czcionka->save();
            }
        }
    }


    $plk = file('data/projekty.txt');
    shuffle($plk);
    foreach ($plk as $l) {
        $e = explode('|', trim($l));
        $str_projekt = $e[0];
        $c = new Criteria();
        $c->add(ProjektPeer::NAZWA, $str_projekt);
        $projekt = ProjektPeer::doSelectOne($c);
        if (!$projekt) {
            $projekt = new Projekt();
            $projekt->setNazwa($str_projekt);
            $projekt->setSlug(string2slug($str_projekt));
            $projekt->save();
        }
        $tmp = explode(',', trim($e[1]));
        foreach ($tmp as $str_czcionka) {
            $str_czcionka = trim($str_czcionka);
            $c = new Criteria();
            $c->add(CzcionkaPeer::NAZWA, $str_czcionka);
            $czcionka = CzcionkaPeer::doSelectOne($c);
            if ($czcionka) {
                $phf = new ProjektHasCzcionka();
                $phf->setProjekt($projekt);
                $phf->setCzcionka($czcionka);
                $phf->save();
            }
        }
    }


  }
}
