<?php

/**
 * Rzeka form base class.
 *
 * @method Rzeka getObject() Returns the current form's model object
 *
 * @package    rzeki
 * @subpackage form
 * @author     Your name here
 */
abstract class BaseRzekaForm extends BaseFormPropel
{
  public function setup()
  {
    $this->setWidgets(array(
      'rzeka_id' => new sfWidgetFormInputHidden(),
      'nazwa'    => new sfWidgetFormInputText(),
      'dlugosc'  => new sfWidgetFormInputText(),
    ));

    $this->setValidators(array(
      'rzeka_id' => new sfValidatorChoice(array('choices' => array($this->getObject()->getRzekaId()), 'empty_value' => $this->getObject()->getRzekaId(), 'required' => false)),
      'nazwa'    => new sfValidatorString(array('max_length' => 45, 'required' => false)),
      'dlugosc'  => new sfValidatorInteger(array('min' => -2147483648, 'max' => 2147483647, 'required' => false)),
    ));

    $this->widgetSchema->setNameFormat('rzeka[%s]');

    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);

    parent::setup();
  }

  public function getModelName()
  {
    return 'Rzeka';
  }


}
