<?php

class propelImportdanychTask extends sfBaseTask
{
  protected function configure()
  {
    // // add your own arguments here
    // $this->addArguments(array(
    //   new sfCommandArgument('my_arg', sfCommandArgument::REQUIRED, 'My argument'),
    // ));

    $this->addOptions(array(
      new sfCommandOption('application', null, sfCommandOption::PARAMETER_REQUIRED, 'The application name'),
      new sfCommandOption('env', null, sfCommandOption::PARAMETER_REQUIRED, 'The environment', 'dev'),
      new sfCommandOption('connection', null, sfCommandOption::PARAMETER_REQUIRED, 'The connection name', 'propel'),
      // add your own options here
    ));

    $this->namespace        = 'propel';
    $this->name             = 'import-danych';
    $this->briefDescription = '';
    $this->detailedDescription = <<<EOF
The [propel:import-danych|INFO] task does things.
Call it with:

  [php symfony propel:import-danych|INFO]
EOF;
  }

  protected function execute($arguments = array(), $options = array())
  {
    // initialize the database connection
    $databaseManager = new sfDatabaseManager($this->configuration);
    $connection = $databaseManager->getDatabase($options['connection'])->getConnection();

    // add your code here


    require_once 'lib/slugs.inc.php';
    require_once 'lib/vh-array.inc.php';
    require_once 'lib/mimetypes.inc.php';
    require_once 'lib/zera.inc.php';

    ZadaniePeer::doDeleteAll();
    RozdzialPeer::doDeleteAll();
    
    //rozdzialy
    $tmp_rozdzialy = string2HArray(file_get_contents('data/dane-zbior-zadan/rozdzialy.txt'));
    foreach ($tmp_rozdzialy['items'] as $tmp_rozdzial) {
        $dane = array(
            'tytul'  => $tmp_rozdzial[0],
            'slug' => string2slug($tmp_rozdzial[0]),
            'numer' => $tmp_rozdzial[1],
        );
        RozdzialPeer::insert($dane);
    }

    //zadania
    $plks = glob('data/dane-zbior-zadan/txt/*.txt');
    foreach ($plks as $plk) {
        echo $plk . "\n";
        preg_match('/^(\d+)-(\d+)\.txt$/', basename($plk), $m);

        $nr_rozdzialu = $m[1];
        $nr_zadania = $m[2];

        echo $nr_rozdzialu . "\n";

        $rozdzial = RozdzialPeer::retrieveByNumer($nr_rozdzialu);
        if (!$rozdzial) {
            die('blad ###1');
        }

        $slug =
            uzupelnij_int_zerami($nr_rozdzialu, 2) . '-' .
            uzupelnij_int_zerami($nr_zadania, 2);


        $dane = array(
            'numer' => $nr_zadania,
            'slug' => $slug,
            'tresc'  => file_get_contents($plk),
            'rozdzial_id' => $rozdzial->getRozdzialId()
        );
        
        $np_cpp = str_replace('txt', 'cpp', $plk);

        echo $np_cpp . "\n";

        if (file_exists($np_cpp)) {
            $dane['odpowiedz'] = htmlspecialchars(file_get_contents($np_cpp));
        }

        ZadaniePeer::insert($dane);
    }


  }
}
