<?php

/**
 * Piosenka form base class.
 *
 * @method Piosenka getObject() Returns the current form's model object
 *
 * @package    piosenki-wojskowe
 * @subpackage form
 * @author     Your name here
 */
abstract class BasePiosenkaForm extends BaseFormPropel
{
  public function setup()
  {
    $this->setWidgets(array(
      'piosenka_id' => new sfWidgetFormInputHidden(),
      'tytul'       => new sfWidgetFormInputText(),
      'tresc'       => new sfWidgetFormTextarea(),
    ));

    $this->setValidators(array(
      'piosenka_id' => new sfValidatorChoice(array('choices' => array($this->getObject()->getPiosenkaId()), 'empty_value' => $this->getObject()->getPiosenkaId(), 'required' => false)),
      'tytul'       => new sfValidatorString(array('max_length' => 128, 'required' => false)),
      'tresc'       => new sfValidatorString(array('required' => false)),
    ));

    $this->widgetSchema->setNameFormat('piosenka[%s]');

    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);

    parent::setup();
  }

  public function getModelName()
  {
    return 'Piosenka';
  }


}
