<?php

class propelImportdanychTask extends sfBaseTask
{
  protected function configure()
  {
    // // add your own arguments here
    // $this->addArguments(array(
    //   new sfCommandArgument('my_arg', sfCommandArgument::REQUIRED, 'My argument'),
    // ));

    $this->addOptions(array(
      new sfCommandOption('application', null, sfCommandOption::PARAMETER_REQUIRED, 'The application name'),
      new sfCommandOption('env', null, sfCommandOption::PARAMETER_REQUIRED, 'The environment', 'dev'),
      new sfCommandOption('connection', null, sfCommandOption::PARAMETER_REQUIRED, 'The connection name', 'propel'),
      // add your own options here
    ));

    $this->namespace        = 'propel';
    $this->name             = 'import-danych';
    $this->briefDescription = '';
    $this->detailedDescription = <<<EOF
The [propel:import-danych|INFO] task does things.
Call it with:

  [php symfony propel:import-danych|INFO]
EOF;
  }

  protected function execute($arguments = array(), $options = array())
  {
    // initialize the database connection
    $databaseManager = new sfDatabaseManager($this->configuration);
    $connection = $databaseManager->getDatabase($options['connection'])->getConnection();

    // add your code here

    require_once 'lib/slugs.inc.php';
    require_once 'lib/vh-array.inc.php';
    require_once 'lib/mimetypes.inc.php';

    GrupaPeer::doDeleteAll();
    ImgPeer::doDeleteAll();
    MenuPeer::doDeleteAll();
    PlikPeer::doDeleteAll();
    PuPeer::doDeleteAll();
    SkrotPeer::doDeleteAll();
    SkrotyPeer::doDeleteAll();

    //ilustracje
    $plks = glob('data/dane/ilustracje/*.png');
    foreach ($plks as $plk) {
        $dane_img = array(
            'img'  => file_get_contents($plk),
            'slug' => basename($plk)
        );
        ImgPeer::insert($dane_img);
    }

    //download
    $plks = glob('data/dane/download/*.*');
    foreach ($plks as $plk) {
        $path_parts = pathinfo($plk);
        $dane_plik = array(
            'typmime' => get_mimetype_on_ext($path_parts['extension']),
            'dane'    => file_get_contents($plk),
            'slug'    => basename($plk)
        );
        PlikPeer::insert($dane_plik);
    }

    //menu
    $plk = file_get_contents('data/dane/menu/00lista.log');
    $d = string2HArray($plk);
    foreach ($d['items'] as $tmp) {
        $nazwapliku = $tmp[2];
        $dane_menu = array(
            'slug'  => $tmp[0],
            'tytul' => $tmp[1],
            'tresc' => file_get_contents('data/dane/menu/' . $nazwapliku)
        );
        MenuPeer::insert($dane_menu);
    }

    //podręcznik użytkownika
    $plk = file_get_contents('data/dane/pu/00lista.log');
    $d = string2HArray($plk);
    foreach ($d['items'] as $tmp) {
        $nazwapliku = $tmp[2];
        $dane_pu = array(
            'slug'  => $tmp[0],
            'tytul' => $tmp[1],
            'tresc' => file_get_contents('data/dane/pu/' . $nazwapliku)
        );
        PuPeer::insert($dane_pu);
    }

    //skróty
    $plk = file_get_contents('data/dane/skroty/00lista.log');
    $d = string2HArray($plk);
    foreach ($d['items'] as $tmp) {
        $nazwapliku = $tmp[2];
        $dane_skroty = array(
            'slug'  => $tmp[0],
            'tytul' => $tmp[1],
            'tresc' => file_get_contents('data/dane/skroty/' . $nazwapliku)
        );
        $skroty = SkrotyPeer::insert($dane_skroty);
        $grupy_tmp = preg_split('/\r?\n@\r?\n/', $dane_skroty['tresc']);
        foreach ($grupy_tmp as $tmp_grupa) {
            $dane_grupa = array(
                'skroty_id'  => $skroty->getSkrotyId()
            );
            $grupa = GrupaPeer::insert($dane_grupa);
            $tmp_skroty = string2HArray($tmp_grupa);
            foreach ($tmp_skroty['items'] as $tmp_skrot) {
                $dane_skrotu = array(
                    'grupa_id' => $grupa->getGrupaId(),
                    'skrot'    => $tmp_skrot[0],
                    'opis'     => $tmp_skrot[1],
                    'kod'      => $tmp_skrot[2],
                );
                SkrotPeer::insert($dane_skrotu);
            }
        }
    }
  }
}
