<?php

/**
 * Skrot filter form base class.
 *
 * @package    noth
 * @subpackage filter
 * @author     Your name here
 */
abstract class BaseSkrotFormFilter extends BaseFormFilterPropel
{
  public function setup()
  {
    $this->setWidgets(array(
      'skrot'    => new sfWidgetFormFilterInput(),
      'opis'     => new sfWidgetFormFilterInput(),
      'kod'      => new sfWidgetFormFilterInput(),
      'grupa_id' => new sfWidgetFormPropelChoice(array('model' => 'Grupa', 'add_empty' => true)),
    ));

    $this->setValidators(array(
      'skrot'    => new sfValidatorPass(array('required' => false)),
      'opis'     => new sfValidatorPass(array('required' => false)),
      'kod'      => new sfValidatorPass(array('required' => false)),
      'grupa_id' => new sfValidatorPropelChoice(array('required' => false, 'model' => 'Grupa', 'column' => 'grupa_id')),
    ));

    $this->widgetSchema->setNameFormat('skrot_filters[%s]');

    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);

    parent::setup();
  }

  public function getModelName()
  {
    return 'Skrot';
  }

  public function getFields()
  {
    return array(
      'skrot_id' => 'Number',
      'skrot'    => 'Text',
      'opis'     => 'Text',
      'kod'      => 'Text',
      'grupa_id' => 'ForeignKey',
    );
  }
}
