<?php

/**
 * Pokoj form base class.
 *
 * @method Pokoj getObject() Returns the current form's model object
 *
 * @package    angaze
 * @subpackage form
 * @author     Your name here
 */
abstract class BasePokojForm extends BaseFormPropel
{
  public function setup()
  {
    $this->setWidgets(array(
      'pokoj_id'   => new sfWidgetFormInputHidden(),
      'numer'      => new sfWidgetFormInputText(),
      'telefon'    => new sfWidgetFormInputText(),
      'slug'       => new sfWidgetFormInputText(),
      'sortowanie' => new sfWidgetFormInputText(),
    ));

    $this->setValidators(array(
      'pokoj_id'   => new sfValidatorChoice(array('choices' => array($this->getObject()->getPokojId()), 'empty_value' => $this->getObject()->getPokojId(), 'required' => false)),
      'numer'      => new sfValidatorString(array('max_length' => 20, 'required' => false)),
      'telefon'    => new sfValidatorString(array('max_length' => 20, 'required' => false)),
      'slug'       => new sfValidatorString(array('max_length' => 128)),
      'sortowanie' => new sfValidatorInteger(array('min' => -2147483648, 'max' => 2147483647, 'required' => false)),
    ));

    $this->validatorSchema->setPostValidator(
      new sfValidatorPropelUnique(array('model' => 'Pokoj', 'column' => array('slug')))
    );

    $this->widgetSchema->setNameFormat('pokoj[%s]');

    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);

    parent::setup();
  }

  public function getModelName()
  {
    return 'Pokoj';
  }


}
