<?php

/**
 * pracownik actions.
 *
 * @package    angaze
 * @subpackage pracownik
 * @author     Your name here
 */
class pracownikActions extends sfActions
{
  public function executeIndex(sfWebRequest $request)
  {
    $this->Pracowniks = PracownikPeer::doSelect(new Criteria());
  }

  public function executeShow(sfWebRequest $request)
  {
    $this->Pracownik = PracownikPeer::retrieveBySlug($request->getParameter('slug'));
    $this->forward404Unless($this->Pracownik);
  }

  public function executeNew(sfWebRequest $request)
  {
    $this->form = new PracownikForm();
  }

  public function executeCreate(sfWebRequest $request)
  {
    $this->forward404Unless($request->isMethod(sfRequest::POST));

    $this->form = new PracownikForm();

    $this->processForm($request, $this->form);

    $this->setTemplate('new');
  }

  public function executeEdit(sfWebRequest $request)
  {
    $this->forward404Unless($Pracownik = PracownikPeer::retrieveByPk($request->getParameter('pracownik_id')), sprintf('Object Pracownik does not exist (%s).', $request->getParameter('pracownik_id')));
    $this->form = new PracownikForm($Pracownik);
  }

  public function executeUpdate(sfWebRequest $request)
  {
    $this->forward404Unless($request->isMethod(sfRequest::POST) || $request->isMethod(sfRequest::PUT));
    $this->forward404Unless($Pracownik = PracownikPeer::retrieveByPk($request->getParameter('pracownik_id')), sprintf('Object Pracownik does not exist (%s).', $request->getParameter('pracownik_id')));
    $this->form = new PracownikForm($Pracownik);

    $this->processForm($request, $this->form);

    $this->setTemplate('edit');
  }

  public function executeDelete(sfWebRequest $request)
  {
    $request->checkCSRFProtection();

    $this->forward404Unless($Pracownik = PracownikPeer::retrieveByPk($request->getParameter('pracownik_id')), sprintf('Object Pracownik does not exist (%s).', $request->getParameter('pracownik_id')));
    $Pracownik->delete();

    $this->redirect('pracownik/index');
  }

  protected function processForm(sfWebRequest $request, sfForm $form)
  {
    $form->bind($request->getParameter($form->getName()), $request->getFiles($form->getName()));
    if ($form->isValid())
    {
      $Pracownik = $form->save();

      $this->redirect('pracownik/edit?pracownik_id='.$Pracownik->getPracownikId());
    }
  }


    public function executeInfo(sfWebRequest $request)
    {
        $this->Pracownik = PracownikPeer::retrieveBySlug($request->getParameter('slug'));
        $this->forward404Unless($this->Pracownik);
    }


    public function executeZestawienie(sfWebRequest $request)
    {
        $this->Pracowniks = PracownikPeer::doSelect(new Criteria());
    }

    public function executeObciazenie(sfWebRequest $request)
    {
        $this->obciazenie_pracownikow = PracownikPeer::obciazeniePracownikow();
        $this->Pracowniks = PracownikPeer::doSelect(new Criteria());
    }


}
