<?php

class propelImportdanychTask extends sfBaseTask
{

    protected function configure()
    {
        // // add your own arguments here
        // $this->addArguments(array(
        //   new sfCommandArgument('my_arg', sfCommandArgument::REQUIRED, 'My argument'),
        // ));

        $this->addOptions(array(
            new sfCommandOption('application', null, sfCommandOption::PARAMETER_REQUIRED, 'The application name'),
            new sfCommandOption('env', null, sfCommandOption::PARAMETER_REQUIRED, 'The environment', 'dev'),
            new sfCommandOption('connection', null, sfCommandOption::PARAMETER_REQUIRED, 'The connection name', 'propel'),
                // add your own options here
        ));

        $this->namespace = 'propel';
        $this->name = 'import-danych';
        $this->briefDescription = '';
        $this->detailedDescription = <<<EOF
The [propel:import-danych|INFO] task does things.
Call it with:

  [php symfony propel:import-danych|INFO]
EOF;
    }

    protected function execute($arguments = array(), $options = array())
    {
        // initialize the database connection
        $databaseManager = new sfDatabaseManager($this->configuration);
        $connection = $databaseManager->getDatabase($options['connection'])->getConnection();

        PrzydzialPeer::doDeleteAll();
        PracownikPeer::doDeleteAll();
        PokojPeer::doDeleteAll();
        StanowiskoPeer::doDeleteAll();
        KatedraPeer::doDeleteAll();
        PrzedmiotPeer::doDeleteAll();
        RodzajzajecPeer::doDeleteAll();
        KierunekPeer::doDeleteAll();
        RodzajstudiowPeer::doDeleteAll();
        WydzialPeer::doDeleteAll();


        /*
         * STANOWISKA
         *
         */
        $plk = trim(file_get_contents('data/txt/stanowiska.txt'));
        $plk = myString::uncomment_and_trim($plk);
        $dane = myString::string2HArray($plk, ':');
        shuffle($dane['items']);
        foreach ($dane['items'] as $wiersz) {

            $dane = array(
                'skrot' => trim($wiersz[0]),
                'pensum' => trim($wiersz[1]),
                'sortowanie' => trim($wiersz[2]),
                'nazwa' => trim($wiersz[3]),
                'slug' => myString::string2slug($wiersz[3])
            );

            StanowiskoPeer::insertIfNotExists($dane);
        }



        /*
         * POKOJE
         *
         */
        $plk = trim(file_get_contents('data/txt/pokoje.txt'));
        $plk = myString::uncomment_and_trim($plk);
        $dane = myString::string2HArray($plk, ':');
        shuffle($dane['items']);
        foreach ($dane['items'] as $wiersz) {

            $dane = array(
                'numer' => trim($wiersz[0]),
                'telefon' => trim($wiersz[1]),
                'slug' => myString::string2slug($wiersz[0]),
                'sortowanie' => (int) ($wiersz[0])
            );

            PokojPeer::insertIfNotExists($dane);
        }

        /*
         * WYDZIAŁY
         *
         */
        $plk = trim(file_get_contents('data/txt/wydzialy.txt'));
        $plk = myString::uncomment_and_trim($plk);
        $dane = myString::string2HArray($plk, ':');
        shuffle($dane['items']);
        foreach ($dane['items'] as $wiersz) {

            $dane = array(
                'nazwa' => trim($wiersz[0]),
                'skrot' => trim($wiersz[1]),
                'slug' => myString::string2slug($wiersz[0])
            );

            WydzialPeer::insertIfNotExists($dane);
        }

        /*
         * KATEDRY
         *
         */
        $plk = trim(file_get_contents('data/txt/katedry.txt'));
        $plk = myString::uncomment_and_trim($plk);
        $dane = myString::string2HArray($plk, ':');
        shuffle($dane['items']);
        foreach ($dane['items'] as $wiersz) {

            $nazwa = trim($wiersz[0]);
            $skrot = trim($wiersz[1]);
            $wydzial = trim($wiersz[2]);
            $slug = myString::string2slug($nazwa);

            $c = new Criteria();
            $c->add(WydzialPeer::SKROT, $wydzial);
            $objWydzial = WydzialPeer::doSelectOne($c);
            if (!$objWydzial) {
                die('error katedra #1');
            }


            $dane = array(
                'nazwa' => $nazwa,
                'skrot' => $skrot,
                'wydzial_id' => $objWydzial->getWydzialId(),
                'slug' => $slug
            );

            KatedraPeer::insertIfNotExists($dane);
        }


        /*
         * PRACOWNICY
         *
         */
        $plk = trim(file_get_contents('data/txt/pracownicy.txt'));
        $plk = myString::uncomment_and_trim($plk);
        $dane = myString::string2HArray($plk, ':');
        shuffle($dane['items']);
        foreach ($dane['items'] as $wiersz) {
            $tytul = trim($wiersz[0]);
            $imie = trim($wiersz[1]);
            $nazwisko = trim($wiersz[2]);
            $stanowisko = trim($wiersz[3]);
            $skrot = trim($wiersz[4]);
            $pokoj = trim($wiersz[5]);
            $katedra = trim($wiersz[6]);
            $slug = myString::string2slug($nazwisko . ' ' . $imie);

            $c = new Criteria();
            $c->add(StanowiskoPeer::NAZWA, $stanowisko);
            $objStanowisko = StanowiskoPeer::doSelectOne($c);
            if (!$objStanowisko) {
                die('error pracownik #1');
            }

            $c = new Criteria();
            $c->add(PokojPeer::NUMER, $pokoj);
            $objPokoj = PokojPeer::doSelectOne($c);
            if (!$objPokoj) {
                die('error pracownik #2');
            }

            $c = new Criteria();
            $c->add(KatedraPeer::SKROT, $katedra);
            $objKatedra = KatedraPeer::doSelectOne($c);
            if (!$objKatedra) {
                die('error pracownik #3');
            }

            $dane = array(
                'tytul' => $tytul,
                'imie' => $imie,
                'nazwisko' => $nazwisko,
                'slug' => $slug,
                'skrot' => $skrot,
                'stanowisko_id' => $objStanowisko->getStanowiskoId(),
                'pokoj_id' => $objPokoj->getPokojId(),
                'katedra_id' => $objKatedra->getKatedraId(),
            );

            PracownikPeer::insertIfNotExists($dane);
        }


        /*
         * RODZAJ STUDIOW
         *
         */
        $plk = trim(file_get_contents('data/txt/rodzaj-studiow.txt'));
        $plk = myString::uncomment_and_trim($plk);
        $dane = myString::string2HArray($plk, ':');
        shuffle($dane['items']);
        foreach ($dane['items'] as $wiersz) {

            $dane = array(
                'nazwa' => trim($wiersz[0]),
                'semestry' => trim($wiersz[1]),
                'lata' => trim($wiersz[2]),
                'skrot' => trim($wiersz[3]),
                'slug' => myString::string2slug($wiersz[0]),
            );

            RodzajstudiowPeer::insertIfNotExists($dane);
        }


        /*
         * RODZAJ ZAJĘĆ
         *
         */
        $plk = trim(file_get_contents('data/txt/rodzaj-zajec.txt'));
        $plk = myString::uncomment_and_trim($plk);
        $dane = myString::string2HArray($plk, ':');
        shuffle($dane['items']);
        foreach ($dane['items'] as $wiersz) {
            $dane = array(
                'nazwa' => trim($wiersz[0]),
                'skrot' => trim($wiersz[1]),
                'grupy' => trim($wiersz[2]),
                'sortowanie' => trim($wiersz[3]),
                'slug' => myString::string2slug($wiersz[0]),
            );

            RodzajzajecPeer::insertIfNotExists($dane);
        }


        /*
         * KIERUNKI
         *
         */
        $plk = trim(file_get_contents('data/txt/kierunki.txt'));
        $plk = myString::uncomment_and_trim($plk);
        $dane = myString::string2HArray($plk, ':');
        shuffle($dane['items']);
        foreach ($dane['items'] as $wiersz) {

            $nazwa = trim($wiersz[0]);
            $skrot = trim($wiersz[1]);
            $sortowanie = trim($wiersz[2]);
            $wydzial = trim($wiersz[3]);
            $rodzajstudiow = trim($wiersz[4]);
            $slug = myString::string2slug($skrot);


            $c = new Criteria();
            $c->add(WydzialPeer::SKROT, $wydzial);
            $objWydzial = WydzialPeer::doSelectOne($c);
            if (!$objWydzial) {
                die('error katedra #1');
            }

            $c = new Criteria();
            $c->add(RodzajstudiowPeer::NAZWA, $rodzajstudiow);
            $objRodzajstudiow = RodzajstudiowPeer::doSelectOne($c);
            if (!$objRodzajstudiow) {
                die('error kierunki #1');
            }

            $dane = array(
                'nazwa' => $nazwa,
                'skrot' => $skrot,
                'sortowanie' => $sortowanie,
                'slug' => $slug,
                'wydzial_id' => $objWydzial->getWydzialId(),
                'rodzajstudiow_id' => $objRodzajstudiow->getRodzajstudiowId()
            );

            KierunekPeer::insertIfNotExists($dane);
        }



        /*
         * PRZEDMIOTY
         *
         */
        $plk = trim(file_get_contents('data/txt/przedmioty.txt'));
        $plk = myString::uncomment_and_trim($plk);
        $plk = explode("\r\n", $plk);
        $tmpCount = count($plk);
        for ($i = 0; $i < $tmpCount; $i++) {

            $wiersz = explode(':', trim($plk[$i]));

            if ($plk[$i][0] === '@') {
                //ustalamy dane wstawianego rekordu
                //$kierunek_id
                //$semestr


                if (trim($wiersz[0]) === '@KIERUNEK') {
                    $kierunek = trim($wiersz[1]);
                    $rodzajstudiow = trim($wiersz[2]);

                    $c = new Criteria();
                    $cton1 = $c->getNewCriterion(KierunekPeer::NAZWA, $kierunek);
                    $cton2 = $c->getNewCriterion(RodzajstudiowPeer::NAZWA, $rodzajstudiow);
                    $cton1->addAnd($cton2);
                    $c->add($cton1);
                    $c->addJoin(RodzajstudiowPeer::RODZAJSTUDIOW_ID, KierunekPeer::RODZAJSTUDIOW_ID);

                    $objKierunek = KierunekPeer::doSelectOne($c);
                    if (!$objKierunek) {
                        die('error przedmioty #1');
                    }
                } else if (trim($wiersz[0]) === '@SEMESTR') {
                    $semestr = trim($wiersz[1]);
                    $rok = (int) floor(($semestr + 1) / 2);

                    if ($semestr % 2 === 1) {
                        $zimalato = 1;
                    } else {
                        $zimalato = 0;
                    }
                };
            } else {

                $nazwa = trim($wiersz[0]);
                $rodzajzajec = trim($wiersz[1]);
                $liczbagrup = trim($wiersz[2]);
                $godz = trim($wiersz[3]);
                $zal = trim($wiersz[4]);
                $skrot = trim($wiersz[5]);


                $c = new Criteria();
                $c->add(RodzajzajecPeer::NAZWA, $rodzajzajec);
                $objRodzajzajec = RodzajzajecPeer::doSelectOne($c);
                if (!$objRodzajzajec) {
                    die('error przedmioty #3');
                }

                $slug = myString::string2slug($nazwa . ' ' . $objKierunek->getSlug() . ' ' . $objRodzajzajec->getSlug() . ' ' . $semestr);

                $przedmiot = new Przedmiot();
                $przedmiot->setNazwa($nazwa);
                $przedmiot->setRodzajzajec($objRodzajzajec);
                $przedmiot->setLiczbagrup($liczbagrup);
                $przedmiot->setGodz($godz);
                $przedmiot->setZal($zal);
                $przedmiot->setSkrot($skrot);
                $przedmiot->setSlug($slug);
                $przedmiot->setKierunek($objKierunek);
                $przedmiot->setZimalato($zimalato);
                $przedmiot->setSemestr($semestr);
                $przedmiot->setRok($rok);
                $przedmiot->setOdbywaSie(1);

                $przedmiot->save();
            }
        }





        /*
         * PUSTE PRZYDZIAŁY
         *
         */
        $przedmioty = PrzedmiotPeer::doSelect(new Criteria());
        foreach ($przedmioty as $przedmiot) {
            for ($i = 1; $i <= $przedmiot->getLiczbagrup(); $i++) {
                $przydzial = new Przydzial();
                $przydzial->setPrzedmiot($przedmiot);
                $przydzial->setNumergrupy($i);
                $przydzial->save();
            };
        }



        /*
         * Losowe przydziały
         *
         */
        $pracownicy = PracownikPeer::doSelect(new Criteria());
        shuffle($pracownicy);
        $liczba_pracownikow = count($pracownicy);

        $przydzialy = PrzydzialPeer::doSelect(new Criteria());
        shuffle($przydzialy);
        $przydzialy = array_slice($przydzialy, 0, (int) (0.9 * count($przydzialy)));
        shuffle($przydzialy);
        foreach ($przydzialy as $przydzial) {
            $indeks = rand(0, $liczba_pracownikow - 1);
            $przydzial->setPracownik($pracownicy[$indeks]);
            $przydzial->save();
        }
    }

}
