
# This is a fix for InnoDB in MySQL >= 4.1.x
# It "suspends judgement" for fkey relationships until are tables are set.
SET FOREIGN_KEY_CHECKS = 0;

#-----------------------------------------------------------------------------
#-- wydzial
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `wydzial`;


CREATE TABLE `wydzial`
(
	`wydzial_id` INTEGER  NOT NULL AUTO_INCREMENT,
	`nazwa` VARCHAR(45),
	`skrot` VARCHAR(20),
	`slug` VARCHAR(128)  NOT NULL,
	PRIMARY KEY (`wydzial_id`),
	UNIQUE KEY `u_slug` (`slug`)
)Type=InnoDB;

#-----------------------------------------------------------------------------
#-- pokoj
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `pokoj`;


CREATE TABLE `pokoj`
(
	`pokoj_id` INTEGER  NOT NULL AUTO_INCREMENT,
	`numer` VARCHAR(20),
	`telefon` VARCHAR(20),
	`slug` VARCHAR(128)  NOT NULL,
	`sortowanie` INTEGER default 999999999,
	PRIMARY KEY (`pokoj_id`),
	UNIQUE KEY `u_slug` (`slug`)
)Type=InnoDB;

#-----------------------------------------------------------------------------
#-- stanowisko
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `stanowisko`;


CREATE TABLE `stanowisko`
(
	`stanowisko_id` INTEGER  NOT NULL AUTO_INCREMENT,
	`nazwa` VARCHAR(45),
	`skrot` VARCHAR(20),
	`pensum` INTEGER,
	`sortowanie` INTEGER,
	`slug` VARCHAR(128)  NOT NULL,
	PRIMARY KEY (`stanowisko_id`),
	UNIQUE KEY `u_slug` (`slug`)
)Type=InnoDB;

#-----------------------------------------------------------------------------
#-- rodzajstudiow
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `rodzajstudiow`;


CREATE TABLE `rodzajstudiow`
(
	`rodzajstudiow_id` INTEGER  NOT NULL AUTO_INCREMENT,
	`nazwa` VARCHAR(45),
	`skrot` VARCHAR(20),
	`semestry` INTEGER,
	`lata` INTEGER,
	`slug` VARCHAR(128)  NOT NULL,
	PRIMARY KEY (`rodzajstudiow_id`),
	UNIQUE KEY `u_slug` (`slug`)
)Type=InnoDB;

#-----------------------------------------------------------------------------
#-- rodzajzajec
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `rodzajzajec`;


CREATE TABLE `rodzajzajec`
(
	`rodzajzajec_id` INTEGER  NOT NULL AUTO_INCREMENT,
	`nazwa` VARCHAR(45),
	`skrot` VARCHAR(20),
	`grupy` INTEGER,
	`sortowanie` INTEGER,
	`slug` VARCHAR(128)  NOT NULL,
	PRIMARY KEY (`rodzajzajec_id`),
	UNIQUE KEY `u_slug` (`slug`)
)Type=InnoDB;

#-----------------------------------------------------------------------------
#-- katedra
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `katedra`;


CREATE TABLE `katedra`
(
	`katedra_id` INTEGER  NOT NULL AUTO_INCREMENT,
	`nazwa` VARCHAR(45),
	`skrot` VARCHAR(20),
	`wydzial_id` INTEGER,
	`slug` VARCHAR(128)  NOT NULL,
	PRIMARY KEY (`katedra_id`),
	UNIQUE KEY `u_slug` (`slug`),
	KEY `fk_katedra_wydzial1`(`wydzial_id`),
	CONSTRAINT `katedra_FK_1`
		FOREIGN KEY (`wydzial_id`)
		REFERENCES `wydzial` (`wydzial_id`)
		ON DELETE CASCADE
)Type=InnoDB;

#-----------------------------------------------------------------------------
#-- kierunek
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `kierunek`;


CREATE TABLE `kierunek`
(
	`kierunek_id` INTEGER  NOT NULL AUTO_INCREMENT,
	`nazwa` VARCHAR(45),
	`skrot` VARCHAR(20),
	`sortowanie` INTEGER,
	`wydzial_id` INTEGER,
	`rodzajstudiow_id` INTEGER,
	`slug` VARCHAR(128)  NOT NULL,
	PRIMARY KEY (`kierunek_id`),
	UNIQUE KEY `u_slug` (`slug`),
	UNIQUE KEY `u_skrot` (`skrot`),
	KEY `fk_tkierunek_wydzial1`(`wydzial_id`),
	KEY `fk_tkierunek_rodzajstudiow1`(`rodzajstudiow_id`),
	CONSTRAINT `kierunek_FK_1`
		FOREIGN KEY (`wydzial_id`)
		REFERENCES `wydzial` (`wydzial_id`)
		ON DELETE CASCADE,
	CONSTRAINT `kierunek_FK_2`
		FOREIGN KEY (`rodzajstudiow_id`)
		REFERENCES `rodzajstudiow` (`rodzajstudiow_id`)
		ON DELETE CASCADE
)Type=InnoDB;

#-----------------------------------------------------------------------------
#-- pracownik
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `pracownik`;


CREATE TABLE `pracownik`
(
	`pracownik_id` INTEGER  NOT NULL AUTO_INCREMENT,
	`imie` VARCHAR(20),
	`nazwisko` VARCHAR(45),
	`skrot` VARCHAR(20),
	`tytul` VARCHAR(20),
	`pokoj_id` INTEGER,
	`stanowisko_id` INTEGER,
	`katedra_id` INTEGER,
	`slug` VARCHAR(128)  NOT NULL,
	PRIMARY KEY (`pracownik_id`),
	UNIQUE KEY `u_slug` (`slug`),
	KEY `fk_tpracownik_pokoj1`(`pokoj_id`),
	KEY `fk_tpracownik_stanowisko1`(`stanowisko_id`),
	KEY `fk_pracownik_katedra1`(`katedra_id`),
	CONSTRAINT `pracownik_FK_1`
		FOREIGN KEY (`pokoj_id`)
		REFERENCES `pokoj` (`pokoj_id`)
		ON DELETE CASCADE,
	CONSTRAINT `pracownik_FK_2`
		FOREIGN KEY (`stanowisko_id`)
		REFERENCES `stanowisko` (`stanowisko_id`)
		ON DELETE CASCADE,
	CONSTRAINT `pracownik_FK_3`
		FOREIGN KEY (`katedra_id`)
		REFERENCES `katedra` (`katedra_id`)
		ON DELETE CASCADE
)Type=InnoDB;

#-----------------------------------------------------------------------------
#-- przedmiot
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `przedmiot`;


CREATE TABLE `przedmiot`
(
	`przedmiot_id` INTEGER  NOT NULL AUTO_INCREMENT,
	`nazwa` VARCHAR(255),
	`skrot` VARCHAR(128),
	`godz` INTEGER,
	`zal` VARCHAR(20),
	`liczbagrup` INTEGER,
	`semestr` INTEGER,
	`rok` INTEGER,
	`odbywa_sie` INTEGER,
	`nazwa_alternatywna` VARCHAR(45),
	`zimalato` INTEGER,
	`rodzajzajec_id` INTEGER,
	`kierunek_id` INTEGER,
	`slug` VARCHAR(128)  NOT NULL,
	PRIMARY KEY (`przedmiot_id`),
	UNIQUE KEY `u_slug` (`slug`),
	KEY `fk_tprzedmiot_rodzajzajec1`(`rodzajzajec_id`),
	KEY `fk_przedmiot_kierunek1`(`kierunek_id`),
	CONSTRAINT `przedmiot_FK_1`
		FOREIGN KEY (`rodzajzajec_id`)
		REFERENCES `rodzajzajec` (`rodzajzajec_id`)
		ON DELETE CASCADE,
	CONSTRAINT `przedmiot_FK_2`
		FOREIGN KEY (`kierunek_id`)
		REFERENCES `kierunek` (`kierunek_id`)
		ON DELETE CASCADE
)Type=InnoDB;

#-----------------------------------------------------------------------------
#-- przydzial
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `przydzial`;


CREATE TABLE `przydzial`
(
	`przydzial_id` INTEGER  NOT NULL AUTO_INCREMENT,
	`numergrupy` INTEGER,
	`nazwa_alternatywna` INTEGER,
	`pracownik_id` INTEGER,
	`przedmiot_id` INTEGER,
	PRIMARY KEY (`przydzial_id`),
	KEY `fk_tprzydzial_pracownik1`(`pracownik_id`),
	KEY `fk_tprzydzial_przedmiot1`(`przedmiot_id`),
	CONSTRAINT `przydzial_FK_1`
		FOREIGN KEY (`pracownik_id`)
		REFERENCES `pracownik` (`pracownik_id`)
		ON DELETE CASCADE,
	CONSTRAINT `przydzial_FK_2`
		FOREIGN KEY (`przedmiot_id`)
		REFERENCES `przedmiot` (`przedmiot_id`)
		ON DELETE CASCADE
)Type=InnoDB;

# This restores the fkey checks, after having unset them earlier
SET FOREIGN_KEY_CHECKS = 1;
