<?php

/**
 * wydzial actions.
 *
 * @package    angaze
 * @subpackage wydzial
 * @author     Your name here
 */
class wydzialActions extends sfActions
{
  public function executeIndex(sfWebRequest $request)
  {
    $this->Wydzials = WydzialPeer::doSelect(new Criteria());
  }

  public function executeShow(sfWebRequest $request)
  {
    $this->Wydzial = WydzialPeer::retrieveBySlug($request->getParameter('slug'));
    $this->forward404Unless($this->Wydzial);
  }

  public function executeNew(sfWebRequest $request)
  {
    $this->form = new WydzialForm();
  }

  public function executeCreate(sfWebRequest $request)
  {
    $this->forward404Unless($request->isMethod(sfRequest::POST));

    $this->form = new WydzialForm();

    $this->processForm($request, $this->form);

    $this->setTemplate('new');
  }

  public function executeEdit(sfWebRequest $request)
  {
    $this->forward404Unless($Wydzial = WydzialPeer::retrieveByPk($request->getParameter('wydzial_id')), sprintf('Object Wydzial does not exist (%s).', $request->getParameter('wydzial_id')));
    $this->form = new WydzialForm($Wydzial);
  }

  public function executeUpdate(sfWebRequest $request)
  {
    $this->forward404Unless($request->isMethod(sfRequest::POST) || $request->isMethod(sfRequest::PUT));
    $this->forward404Unless($Wydzial = WydzialPeer::retrieveByPk($request->getParameter('wydzial_id')), sprintf('Object Wydzial does not exist (%s).', $request->getParameter('wydzial_id')));
    $this->form = new WydzialForm($Wydzial);

    $this->processForm($request, $this->form);

    $this->setTemplate('edit');
  }

  public function executeDelete(sfWebRequest $request)
  {
    $request->checkCSRFProtection();

    $this->forward404Unless($Wydzial = WydzialPeer::retrieveByPk($request->getParameter('wydzial_id')), sprintf('Object Wydzial does not exist (%s).', $request->getParameter('wydzial_id')));
    $Wydzial->delete();

    $this->redirect('wydzial/index');
  }

  protected function processForm(sfWebRequest $request, sfForm $form)
  {
    $form->bind($request->getParameter($form->getName()), $request->getFiles($form->getName()));
    if ($form->isValid())
    {
      $Wydzial = $form->save();

      $this->redirect('wydzial/edit?wydzial_id='.$Wydzial->getWydzialId());
    }
  }
}
