<?php

/**
 * stanowisko actions.
 *
 * @package    angaze
 * @subpackage stanowisko
 * @author     Your name here
 */
class stanowiskoActions extends sfActions
{
  public function executeIndex(sfWebRequest $request)
  {
    $this->Stanowiskos = StanowiskoPeer::doSelect(new Criteria());
  }

  public function executeShow(sfWebRequest $request)
  {
    $this->Stanowisko = StanowiskoPeer::retrieveBySlug($request->getParameter('slug'));
    $this->forward404Unless($this->Stanowisko);
  }

  public function executeNew(sfWebRequest $request)
  {
    $this->form = new StanowiskoForm();
  }

  public function executeCreate(sfWebRequest $request)
  {
    $this->forward404Unless($request->isMethod(sfRequest::POST));

    $this->form = new StanowiskoForm();

    $this->processForm($request, $this->form);

    $this->setTemplate('new');
  }

  public function executeEdit(sfWebRequest $request)
  {
    $this->forward404Unless($Stanowisko = StanowiskoPeer::retrieveByPk($request->getParameter('stanowisko_id')), sprintf('Object Stanowisko does not exist (%s).', $request->getParameter('stanowisko_id')));
    $this->form = new StanowiskoForm($Stanowisko);
  }

  public function executeUpdate(sfWebRequest $request)
  {
    $this->forward404Unless($request->isMethod(sfRequest::POST) || $request->isMethod(sfRequest::PUT));
    $this->forward404Unless($Stanowisko = StanowiskoPeer::retrieveByPk($request->getParameter('stanowisko_id')), sprintf('Object Stanowisko does not exist (%s).', $request->getParameter('stanowisko_id')));
    $this->form = new StanowiskoForm($Stanowisko);

    $this->processForm($request, $this->form);

    $this->setTemplate('edit');
  }

  public function executeDelete(sfWebRequest $request)
  {
    $request->checkCSRFProtection();

    $this->forward404Unless($Stanowisko = StanowiskoPeer::retrieveByPk($request->getParameter('stanowisko_id')), sprintf('Object Stanowisko does not exist (%s).', $request->getParameter('stanowisko_id')));
    $Stanowisko->delete();

    $this->redirect('stanowisko/index');
  }

  protected function processForm(sfWebRequest $request, sfForm $form)
  {
    $form->bind($request->getParameter($form->getName()), $request->getFiles($form->getName()));
    if ($form->isValid())
    {
      $Stanowisko = $form->save();

      $this->redirect('stanowisko/edit?stanowisko_id='.$Stanowisko->getStanowiskoId());
    }
  }
}
