<?php

/**
 * kierunek actions.
 *
 * @package    angaze
 * @subpackage kierunek
 * @author     Your name here
 */
class kierunekActions extends sfActions
{
  public function executeIndex(sfWebRequest $request)
  {
    $this->Kieruneks = KierunekPeer::doSelect(new Criteria());
  }

  public function executeShow(sfWebRequest $request)
  {
    $this->Kierunek = KierunekPeer::retrieveBySlug($request->getParameter('slug'));
    $this->forward404Unless($this->Kierunek);
  }

  public function executeNew(sfWebRequest $request)
  {
    $this->form = new KierunekForm();
  }

  public function executeCreate(sfWebRequest $request)
  {
    $this->forward404Unless($request->isMethod(sfRequest::POST));

    $this->form = new KierunekForm();

    $this->processForm($request, $this->form);

    $this->setTemplate('new');
  }

  public function executeEdit(sfWebRequest $request)
  {
    $this->forward404Unless($Kierunek = KierunekPeer::retrieveByPk($request->getParameter('kierunek_id')), sprintf('Object Kierunek does not exist (%s).', $request->getParameter('kierunek_id')));
    $this->form = new KierunekForm($Kierunek);
  }

  public function executeUpdate(sfWebRequest $request)
  {
    $this->forward404Unless($request->isMethod(sfRequest::POST) || $request->isMethod(sfRequest::PUT));
    $this->forward404Unless($Kierunek = KierunekPeer::retrieveByPk($request->getParameter('kierunek_id')), sprintf('Object Kierunek does not exist (%s).', $request->getParameter('kierunek_id')));
    $this->form = new KierunekForm($Kierunek);

    $this->processForm($request, $this->form);

    $this->setTemplate('edit');
  }

  public function executeDelete(sfWebRequest $request)
  {
    $request->checkCSRFProtection();

    $this->forward404Unless($Kierunek = KierunekPeer::retrieveByPk($request->getParameter('kierunek_id')), sprintf('Object Kierunek does not exist (%s).', $request->getParameter('kierunek_id')));
    $Kierunek->delete();

    $this->redirect('kierunek/index');
  }

  protected function processForm(sfWebRequest $request, sfForm $form)
  {
    $form->bind($request->getParameter($form->getName()), $request->getFiles($form->getName()));
    if ($form->isValid())
    {
      $Kierunek = $form->save();

      $this->redirect('kierunek/edit?kierunek_id='.$Kierunek->getKierunekId());
    }
  }


    public function executeSemestr(sfWebRequest $request)
    {
        if (
            ($kierunek = KierunekPeer::retrieveBySlug($request->getParameter('slug'))) &&
            ($kierunek->isValidSemestr($request->getParameter('semestr', '?')))
        ) {
            $this->Kierunek = $kierunek;
            $this->Semestr = $request->getParameter('semestr');
            $this->Przedmioty = $kierunek->przedmiotySemestru($this->Semestr);
        }
        $this->forward404Unless($this->Kierunek);
    }

    public function executeRok(sfWebRequest $request)
    {

        if (
            ($kierunek = KierunekPeer::retrieveBySlug($request->getParameter('slug'))) &&
            ($kierunek->isValidRok($request->getParameter('rok', '?')))
        ) {
            $this->Kierunek = $kierunek;
            $this->Rok = $request->getParameter('rok');
            $this->przedmioty_zima = $kierunek->przedmiotySemestru($this->Rok * 2 - 1);
            $this->przedmioty_lato = $kierunek->przedmiotySemestru($this->Rok * 2);

        } else {
            $this->execute_404();
        }
    }


}
