<?php

/**
 * Panstwo form base class.
 *
 * @method Panstwo getObject() Returns the current form's model object
 *
 * @package    kontynenty
 * @subpackage form
 * @author     Your name here
 */
abstract class BasePanstwoForm extends BaseFormPropel
{
  public function setup()
  {
    $this->setWidgets(array(
      'panstwo_id'   => new sfWidgetFormInputHidden(),
      'nazwa'        => new sfWidgetFormInputText(),
      'slug'         => new sfWidgetFormInputText(),
      'kontynent_id' => new sfWidgetFormPropelChoice(array('model' => 'Kontynent', 'add_empty' => false)),
    ));

    $this->setValidators(array(
      'panstwo_id'   => new sfValidatorChoice(array('choices' => array($this->getObject()->getPanstwoId()), 'empty_value' => $this->getObject()->getPanstwoId(), 'required' => false)),
      'nazwa'        => new sfValidatorString(array('max_length' => 45, 'required' => false)),
      'slug'         => new sfValidatorString(array('max_length' => 45, 'required' => false)),
      'kontynent_id' => new sfValidatorPropelChoice(array('model' => 'Kontynent', 'column' => 'kontynent_id')),
    ));

    $this->validatorSchema->setPostValidator(
      new sfValidatorPropelUnique(array('model' => 'Panstwo', 'column' => array('slug')))
    );

    $this->widgetSchema->setNameFormat('panstwo[%s]');

    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);

    parent::setup();
  }

  public function getModelName()
  {
    return 'Panstwo';
  }


}
