<?php

/**
 * Kontynent form base class.
 *
 * @method Kontynent getObject() Returns the current form's model object
 *
 * @package    kontynenty
 * @subpackage form
 * @author     Your name here
 */
abstract class BaseKontynentForm extends BaseFormPropel
{
  public function setup()
  {
    $this->setWidgets(array(
      'kontynent_id' => new sfWidgetFormInputHidden(),
      'nazwa'        => new sfWidgetFormInputText(),
      'slug'         => new sfWidgetFormInputText(),
    ));

    $this->setValidators(array(
      'kontynent_id' => new sfValidatorChoice(array('choices' => array($this->getObject()->getKontynentId()), 'empty_value' => $this->getObject()->getKontynentId(), 'required' => false)),
      'nazwa'        => new sfValidatorString(array('max_length' => 45, 'required' => false)),
      'slug'         => new sfValidatorString(array('max_length' => 45, 'required' => false)),
    ));

    $this->validatorSchema->setPostValidator(
      new sfValidatorPropelUnique(array('model' => 'Kontynent', 'column' => array('slug')))
    );

    $this->widgetSchema->setNameFormat('kontynent[%s]');

    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);

    parent::setup();
  }

  public function getModelName()
  {
    return 'Kontynent';
  }


}
