<?php

/**
 * Zadanie form base class.
 *
 * @method Zadanie getObject() Returns the current form's model object
 *
 * @package    cpp
 * @subpackage form
 * @author     Your name here
 */
abstract class BaseZadanieForm extends BaseFormPropel
{
  public function setup()
  {
    $this->setWidgets(array(
      'zadanie_id'  => new sfWidgetFormInputHidden(),
      'numer'       => new sfWidgetFormInputText(),
      'slug'        => new sfWidgetFormInputText(),
      'tresc'       => new sfWidgetFormTextarea(),
      'odpowiedz'   => new sfWidgetFormTextarea(),
      'rozdzial_id' => new sfWidgetFormPropelChoice(array('model' => 'Rozdzial', 'add_empty' => false)),
    ));

    $this->setValidators(array(
      'zadanie_id'  => new sfValidatorChoice(array('choices' => array($this->getObject()->getZadanieId()), 'empty_value' => $this->getObject()->getZadanieId(), 'required' => false)),
      'numer'       => new sfValidatorInteger(array('min' => -2147483648, 'max' => 2147483647, 'required' => false)),
      'slug'        => new sfValidatorString(array('max_length' => 45, 'required' => false)),
      'tresc'       => new sfValidatorString(array('required' => false)),
      'odpowiedz'   => new sfValidatorString(array('required' => false)),
      'rozdzial_id' => new sfValidatorPropelChoice(array('model' => 'Rozdzial', 'column' => 'rozdzial_id')),
    ));

    $this->widgetSchema->setNameFormat('zadanie[%s]');

    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);

    parent::setup();
  }

  public function getModelName()
  {
    return 'Zadanie';
  }


}
