<?php

/**
 * Zadanie filter form base class.
 *
 * @package    cpp
 * @subpackage filter
 * @author     Your name here
 */
abstract class BaseZadanieFormFilter extends BaseFormFilterPropel
{
  public function setup()
  {
    $this->setWidgets(array(
      'numer'       => new sfWidgetFormFilterInput(),
      'slug'        => new sfWidgetFormFilterInput(),
      'tresc'       => new sfWidgetFormFilterInput(),
      'odpowiedz'   => new sfWidgetFormFilterInput(),
      'rozdzial_id' => new sfWidgetFormPropelChoice(array('model' => 'Rozdzial', 'add_empty' => true)),
    ));

    $this->setValidators(array(
      'numer'       => new sfValidatorSchemaFilter('text', new sfValidatorInteger(array('required' => false))),
      'slug'        => new sfValidatorPass(array('required' => false)),
      'tresc'       => new sfValidatorPass(array('required' => false)),
      'odpowiedz'   => new sfValidatorPass(array('required' => false)),
      'rozdzial_id' => new sfValidatorPropelChoice(array('required' => false, 'model' => 'Rozdzial', 'column' => 'rozdzial_id')),
    ));

    $this->widgetSchema->setNameFormat('zadanie_filters[%s]');

    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);

    parent::setup();
  }

  public function getModelName()
  {
    return 'Zadanie';
  }

  public function getFields()
  {
    return array(
      'zadanie_id'  => 'Number',
      'numer'       => 'Number',
      'slug'        => 'Text',
      'tresc'       => 'Text',
      'odpowiedz'   => 'Text',
      'rozdzial_id' => 'ForeignKey',
    );
  }
}
