<?php

class propelImportdanychTask extends sfBaseTask
{

    protected function configure()
    {
        // // add your own arguments here
        // $this->addArguments(array(
        //   new sfCommandArgument('my_arg', sfCommandArgument::REQUIRED, 'My argument'),
        // ));

        $this->addOptions(array(
            new sfCommandOption('application', null, sfCommandOption::PARAMETER_REQUIRED, 'The application name'),
            new sfCommandOption('env', null, sfCommandOption::PARAMETER_REQUIRED, 'The environment', 'dev'),
            new sfCommandOption('connection', null, sfCommandOption::PARAMETER_REQUIRED, 'The connection name', 'propel'),
                // add your own options here
        ));

        $this->namespace = 'propel';
        $this->name = 'import-danych';
        $this->briefDescription = '';
        $this->detailedDescription = <<<EOF
The [propel:import-danych|INFO] task does things.
Call it with:

  [php symfony propel:import-danych|INFO]
EOF;
    }

    protected function execute($arguments = array(), $options = array())
    {
        // initialize the database connection
        $databaseManager = new sfDatabaseManager($this->configuration);
        $connection = $databaseManager->getDatabase($options['connection'])->getConnection();

        // add your code here


        ZawodnikPeer::doDeleteAll();
        PanstwoPeer::doDeleteAll();
        TurniejPeer::doDeleteAll();

        $tcs = simplexml_load_file('data/tcs.xml');

        foreach ($tcs->turniej as $turniej) {

            $dane_turnieju = array(
                'rok' => $turniej->rok,
            );

            $objTurniej = TurniejPeer::insertIfNotExists($dane_turnieju);

            foreach ($turniej->miejsce as $miejsce) {


                $dane_panstwa = array(
                    'panstwo' => $miejsce->sportowiec->panstwo,
                );

                $objPanstwo = PanstwoPeer::insertIfNotExists($dane_panstwa);

                $dane_zawodnika = array(
                    'imie' => $miejsce->sportowiec->imie,
                    'nazwisko' => $miejsce->sportowiec->nazwisko,
                    'panstwo_id' => $objPanstwo->getPanstwoId(),
                );

                $objZawodnik = ZawodnikPeer::insertIfNotExists($dane_zawodnika);


                $thz = new TurniejHasZawodnik();
                $thz->setZawodnik($objZawodnik);
                $thz->setTurniej($objTurniej);
                $thz->setMiejsce($miejsce->numer);
                try {
                    $thz->save();
                } catch (PropelException $e) {
                    echo 'ERROR: ' . $e->getMessage() . "\n";
                }
            }
        }
    }

}
