<?php

/**
 * Panstwo form base class.
 *
 * @method Panstwo getObject() Returns the current form's model object
 *
 * @package    tcs
 * @subpackage form
 * @author     Your name here
 */
abstract class BasePanstwoForm extends BaseFormPropel
{
  public function setup()
  {
    $this->setWidgets(array(
      'panstwo_id' => new sfWidgetFormInputHidden(),
      'panstwo'    => new sfWidgetFormInputText(),
    ));

    $this->setValidators(array(
      'panstwo_id' => new sfValidatorChoice(array('choices' => array($this->getObject()->getPanstwoId()), 'empty_value' => $this->getObject()->getPanstwoId(), 'required' => false)),
      'panstwo'    => new sfValidatorString(array('max_length' => 128, 'required' => false)),
    ));

    $this->widgetSchema->setNameFormat('panstwo[%s]');

    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);

    parent::setup();
  }

  public function getModelName()
  {
    return 'Panstwo';
  }


}
