<?php

/**
 * TurniejHasZawodnik filter form base class.
 *
 * @package    tcs
 * @subpackage filter
 * @author     Your name here
 */
abstract class BaseTurniejHasZawodnikFormFilter extends BaseFormFilterPropel
{
  public function setup()
  {
    $this->setWidgets(array(
      'turniej_id'  => new sfWidgetFormPropelChoice(array('model' => 'Turniej', 'add_empty' => true)),
      'zawodnik_id' => new sfWidgetFormPropelChoice(array('model' => 'Zawodnik', 'add_empty' => true)),
      'miejsce'     => new sfWidgetFormFilterInput(),
    ));

    $this->setValidators(array(
      'turniej_id'  => new sfValidatorPropelChoice(array('required' => false, 'model' => 'Turniej', 'column' => 'turniej_id')),
      'zawodnik_id' => new sfValidatorPropelChoice(array('required' => false, 'model' => 'Zawodnik', 'column' => 'zawodnik_id')),
      'miejsce'     => new sfValidatorSchemaFilter('text', new sfValidatorInteger(array('required' => false))),
    ));

    $this->widgetSchema->setNameFormat('turniej_has_zawodnik_filters[%s]');

    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);

    parent::setup();
  }

  public function getModelName()
  {
    return 'TurniejHasZawodnik';
  }

  public function getFields()
  {
    return array(
      'thz_id'      => 'Number',
      'turniej_id'  => 'ForeignKey',
      'zawodnik_id' => 'ForeignKey',
      'miejsce'     => 'Number',
    );
  }
}
