<?php

/*
 * This file is part of the Sonata package.
 *
 * (c) Thomas Rabaix <thomas.rabaix@sonata-project.org>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Sonata\AdminBundle\Tests\Admin;

use Sonata\AdminBundle\Admin\BaseFieldDescription;
use Sonata\AdminBundle\Admin\AdminInterface;

class BaseFieldDescriptionTest extends \PHPUnit_Framework_TestCase
{
    public function testSetName()
    {
        $description = new FieldDescription();
        $description->setName('foo');

        $this->assertEquals('foo', $description->getFieldName());
        $this->assertEquals('foo', $description->getName());
    }

    public function testOptions()
    {
        $description = new FieldDescription();
        $description->setOption('foo', 'bar');

        $this->assertNull($description->getOption('bar'));
        $this->assertEquals('bar', $description->getOption('foo'));

        $description->mergeOptions(array('settings' => array('value_1', 'value_2')));
        $description->mergeOptions(array('settings' => array('value_1', 'value_3')));

        $this->assertEquals(array('value_1', 'value_2', 'value_1', 'value_3'), $description->getOption('settings'));

        $description->mergeOption('settings', array('value_4'));
        $this->assertEquals(array('value_1', 'value_2', 'value_1', 'value_3', 'value_4'), $description->getOption('settings'));

        $description->mergeOption('bar', array('hello'));

        $this->assertCount(1, $description->getOption('bar'));

        $description->setOption('label', 'trucmuche');
        $this->assertEquals('trucmuche', $description->getLabel());

        $this->assertNull($description->getTemplate());
        $description->setOptions(array('type' => 'integer', 'template' => 'foo.twig.html', 'help' => 'fooHelp'));

        $this->assertEquals('integer', $description->getType());
        $this->assertEquals('foo.twig.html', $description->getTemplate());
        $this->assertEquals('fooHelp', $description->getHelp());

        $this->assertCount(0, $description->getOptions());

        $description->setHelp('Please enter an integer');
        $this->assertEquals('Please enter an integer', $description->getHelp());

        $description->setMappingType('int');
        $this->assertEquals('int', $description->getMappingType());
    }

    public function testAdmin()
    {
        $description = new FieldDescription();

        $admin = $this->getMock('Sonata\AdminBundle\Admin\AdminInterface');
        $description->setAdmin($admin);
        $this->isInstanceOf('Sonata\AdminBundle\Admin\AdminInterface', $description->getAdmin());

        $associationAdmin = $this->getMock('Sonata\AdminBundle\Admin\AdminInterface');
        $associationAdmin->expects($this->once())->method('setParentFieldDescription');

        $this->assertFalse($description->hasAssociationAdmin());
        $description->setAssociationAdmin($associationAdmin);
        $this->assertTrue($description->hasAssociationAdmin());
        $this->isInstanceOf('Sonata\AdminBundle\Admin\AdminInterface', $description->getAssociationAdmin());

        $parent = $this->getMock('Sonata\AdminBundle\Admin\AdminInterface');
        $description->setParent($parent);
        $this->isInstanceOf('Sonata\AdminBundle\Admin\AdminInterface', $description->getParent());
    }

    public function testGetValue()
    {
        $description = new FieldDescription();
        $description->setOption('code', 'getFoo');

        $mock = $this->getMock('stdClass', array('getFoo'));
        $mock->expects($this->once())->method('getFoo')->will($this->returnValue(42));

        $this->assertEquals(42, $description->getFieldValue($mock, 'fake'));
    }

    /**
     * @expectedException Sonata\AdminBundle\Exception\NoValueException
     */
    public function testGetValueNoValueException()
    {
        $description = new FieldDescription();
        $mock = $this->getMock('stdClass', array('getFoo'));

        $description->getFieldValue($mock, 'fake');
    }

    /**
     * @expectedException RuntimeException
     */
    public function testExceptionOnNonArrayOption()
    {
        $description = new FieldDescription();
        $description->setOption('bar', 'hello');
        $description->mergeOption('bar', array('exception'));
    }
}

class FieldDescription extends BaseFieldDescription
{
    function setAssociationMapping($associationMapping)
    {
        // TODO: Implement setAssociationMapping() method.
    }

    function getTargetEntity()
    {
        // TODO: Implement getTargetEntity() method.
    }

    function setFieldMapping($fieldMapping)
    {
        // TODO: Implement setFieldMapping() method.
    }

    function isIdentifier()
    {
        // TODO: Implement isIdentifier() method.
    }

    /**
     * set the parent association mappings information
     *
     * @param array $parentAssociationMappings
     * @return void
     */
    function setParentAssociationMappings(array $parentAssociationMappings)
    {
        // TODO: Implement setParentAssociationMappings() method.
    }

    /**
     * return the value linked to the description
     *
     * @param  $object
     * @return bool|mixed
     */
    function getValue($object)
    {
        // TODO: Implement getValue() method.
    }
}
