<?php

namespace My\MountainBundle\DataFixtures\ORM;

use Doctrine\Common\DataFixtures\FixtureInterface;
use My\FrontendBundle\Entity\Tren;
use Doctrine\Common\Persistence\ObjectManager;

class LoadData implements FixtureInterface
{
    function load(ObjectManager $manager)
    {
        $plks = glob('data/treny/*.txt');
        shuffle($plks);
        foreach ($plks as $plk) {
            $t = file($plk);
            $tytul = trim(array_shift($t));
            $tresc = trim(implode('', $t));

            $numer = basename($plk);
            $numer = str_replace('.txt', '', $numer);
            $numer = ltrim($numer, '0');

            $Tren = new Tren();
            $Tren->setTytul($tytul);
            $Tren->setTresc($tresc);
            $Tren->setNumer($numer);

            $manager->persist($Tren);
        }
        $manager->flush();
    }
}