require 'net/http'

HOST = "www.random.org"
RAND_URL = "/cgi-bin/randnum?col=5&"

def get_random_numbers(count=1, min=0, max=99)
  path = RAND_URL + "num=#{count}&min=#{min}&max=#{max}"
  connection = Net::HTTP.new(HOST)
  response, data = connection.get(path)
  if response.code == "200"
    data.split.collect { |num| num.to_i }
  else
    []
  end
end

DICE_LINES = [
  "+-----+ +-----+ +-----+ +-----+ +-----+ +-----+ ",
  "|     | |  *  | | *   | | * * | | * * | | * * | ",
  "|  *  | |     | |  *  | |     | |  *  | | * * | ",
  "|     | |  *  | |   * | | * * | | * * | | * * | ",
  "+-----+ +-----+ +-----+ +-----+ +-----+ +-----+ "
]

DIE_WIDTH = DICE_LINES[0].length/6

def draw_dice(values)
  DICE_LINES.each do |line|
    for v in values
      print line[(v-1)*DIE_WIDTH, DIE_WIDTH]
      print " "
    end
    puts
  end
end

draw_dice(get_random_numbers(5, 1, 6))
