require "socket"
require "timeout"

ChessServer     = '96.97.98.99'  # Ten adres IP naley zastpi faktycznym adresem serwera.
ChessServerPort = 12000
PeerPort        = 12001

WHITE, BLACK = 0, 1
Colors = %w[White Black]

def draw_board(board)
  puts <<-EOF
+-------------------------------------+
| Namiastka! Rysujemy szachownic...  |
+-------------------------------------+
  EOF
end

def analyze_move(who, move, num, board)
  # Namiastka  czarne figury zawsze wygrywaj po czterech ruchach.
  if who == BLACK and num == 4
    move << "  Szach i mat!"
  end
  true  # Znowu namiastka - zawsze stwierdzamy, e ruch by prawidowy.
end

def my_move(who, lastmove, num, board, sock)
  ok = false
  until ok do
    print "\nTwj ruch: "
    move = STDIN.gets.chomp
    ok = analyze_move(who, move, num, board)
    puts "Nieprawidowy ruch" if not ok
  end
  sock.puts move
  move
end

def other_move(who, move, num, board, sock)
  move = sock.gets.chomp
  puts "\nRuch przeciwnika: #{move}"
  move
end

if ARGV[0]
  myself = ARGV[0]
else
  print "Wpisz swoje dane: "
  myself = STDIN.gets.chomp
end

if ARGV[1]
  opponent_id = ARGV[1]
else
  print "Wpisz dane swojego przeciwnika: "
  opponent_id = STDIN.gets.chomp
end

opponent = opponent_id.split(":")[0]   # Usuwamy nazw komputera.
# Nawizujemy kontakt z serwerem.

socket = TCPSocket.new(ChessServer, ChessServerPort)

response = nil

socket.puts "login #{myself} #{opponent_id}"
socket.flush
response = socket.gets.chomp

name, ipname, color = response.split ":"
color = color.to_i

if color == BLACK            # Kolor figur przeciwnika.
  puts "\nNawizywanie poczenia..."

  server = TCPServer.new(PeerPort)
  session = server.accept

  str = nil
  begin
    timeout(30) do
      str = session.gets.chomp
      if str != "ready"
        raise "Bd protokou: zamiast komunikatu gotowoci otrzymano: #{str}"
      end
    end
  rescue TimeoutError
    raise "Nie otrzymano komunikatu o gotowoci przeciwnika."
  end

  puts "Grasz czarnymi figurami z #{opponent}.\n"

  who = WHITE
  move = nil
  board = nil      # W tym prostym przykadzie nie bdziemy si odwoywali do obiektu szachownicy.
  num = 0
  draw_board(board) # Rysuje szachownic.

  loop do
    num += 1
    move = my_move(who, move, num, board, session)
    draw_board(board)
    case move
      when "resign"
        puts "\nPoddae parti. #{opponent} wygra."
        break
      when /Szach/
        puts "\nWygrae parti z #{opponent}!"
        draw_board(board)
        break
    end
    move = other_move(who, move, num, board, session)
    draw_board(board)
    case move
      when "resign"
        puts "\n#{opponent} podda parti... wygrae!"
        break
      when /Szach/
        puts "\n#{opponent} wygra parti."
        break
    end
  end
else                       # Prbujemy ponownie.
  puts "\nNawizywanie poczenia..."

  socket = TCPSocket.new(ipname, PeerPort)
  socket.puts "ready"

  puts "Grasz czarnymi figurami z #{opponent}.\n"

  who = BLACK
  move = nil
  board = nil       # W tym prostym przykadzie nie bdziemy si odwoywali do obiektu szachownicy.
  num = 0
  draw_board(board)  # Rysuje szachownic.

  loop do
    num += 1
    move = other_move(who, move, num, board, socket)
    draw_board(board)  # Rysuje szachownic po ruchu przeciwnika.
    case move
      when "resign"
        puts "\n#{opponent} podda parti... wygrae!"
        break
      when /Szach/
        puts "\n#{opponent} wygra parti."
        break
    end
    move = my_move(who, move, num, board, socket)
    draw_board(board)
    case move
      when "resign"
        puts "\nPoddae parti. #{opponent} wygra."
        break
      when /Szach/
        puts "\nWygrae parti z #{opponent}!"
        break
    end
  end
  socket.close
end
