require "fileutils"

def recurse(src, dst)
  Dir.mkdir(dst)
  Dir.foreach(src) do |e|
    # Ignorujemy katalogi . i ..
    next if [".",".."].include? e
    fullname = src + "/" + e
    newname = fullname.sub(Regexp.new(Regexp.escape(src)),dst)
    if FileTest::directory?(fullname)
      recurse(fullname,newname)
    elsif FileTest::symlink?(fullname)
      linkname = `ls -l #{fullname}`.sub(/.* -> /,"").chomp
      newlink = linkname.dup
      n = newlink.index($oldname)
      next if n == nil
      n2 = n + $oldname.length - 1
      newlink[n..n2] = $newname
      newlink.sub!(/\/\//,"/")
      # newlink = linkname.sub(Regexp.new(Regexp.escape(src)),dst)
        File.symlink(newlink, newname)
    elsif FileTest::file?(fullname)
      FileUtils.copy(fullname, newname)
    else
      puts "??? :  #{fullname}"
    end
  end
end


# Odpowiednik funkcji main.

if ARGV.size != 2
  puts "Sposb uycia: copytree stara_nazwa nowa_nazwa"
  exit
end

oldname = ARGV[0]
newname = ARGV[1]

if ! FileTest::directory?(oldname)
  puts "Bd: Pierwszy parametr musi wskazywa na istniejcy katalog."
  exit
end

if FileTest::exist?(newname)
  puts "Bd: Plik #{newname} ju istnieje."
  exit
end

oldname = File.expand_path(oldname)
newname = File.expand_path(newname)

$oldname=oldname
$newname=newname

recurse(oldname, newname)
