def compose(*objects)
  threads = []
  for obj in objects do
    threads << Thread.new(obj) do |myobj|
      me = Thread.current
      me[:queue] = []
      myobj.each {|x| me[:queue].push(x) }
    end
  end

  list = [0]                        # Warto rna od nil.
  while list.nitems > 0 do          # Wartoci rne od nil.
    list = []
    for thr in threads
      list << thr[:queue].shift     # Usuwamy po jednym elemencie z kadej listy.
    end
    yield list if list.nitems > 0   # Dopeniamy list wartociami nil.
  end
end

x = [1, 2, 3, 4, 5, 6, 7, 8]
y = "  first\n second\n  third\n fourth\n  fifth\n"
z = %w[a b c d e f]

compose(x, y, z) {|a,b,c| p [a, b, c] }

# Dane wyjciowe:
#
# [1, "  first\n", "a"]
# [2, " second\n", "b"]
# [3, "  third\n", "c"]
# [4, " fourth\n", "d"]
# [5, "  fifth\n", "e"]
# [6, nil, "f"]
# [7, nil, nil]
# [8, nil, nil]
