# Autor:  Shugo Maeda

require 'monitor'

class Queue
  def initialize
    @que = []
    @monitor = Monitor.new
    @empty_cond = @monitor.new_cond
  end

  def enq(obj)
    @monitor.synchronize do
      @que.push(obj)
      @empty_cond.signal
    end
  end
  def deq
    @monitor.synchronize do
      while @que.empty?
        @empty_cond.wait
      end
      return @que.shift
    end
  end
end

class SizedQueue < Queue
  attr :max

  def initialize(max)
    super()
    @max = max
    @full_cond = @monitor.new_cond
  end

  def enq(obj)
    @monitor.synchronize do
      while @que.length >= @max
        @full_cond.wait
      end
      super(obj)
    end
  end

  def deq
    @monitor.synchronize do
      obj = super
      if @que.length < @max
        @full_cond.signal
      end
      return obj
    end
  end

  def max=(max)
    @monitor.synchronize do
      @max = max
      @full_cond.broadcast
    end
  end
 end
require 'thread'

@music  = Mutex.new
@violin = ConditionVariable.new
@bow    = ConditionVariable.new

@violins_free = 2
@bows_free    = 1

def musician(n)
  loop do
    sleep rand(0)
    @music.synchronize do
      @violin.wait(@music) while @violins_free == 0
      @violins_free -= 1
      puts "#{n} dysponuje skrzypcami"
      puts "liczba dostpnych skrzypiec #@violins_free; liczba dostpnych smyczkw #@bows_free"

      @bow.wait(@music) while @bows_free == 0
      @bows_free -= 1
      puts "#{n} dysponuje smyczkiem"
      puts "liczba dostpnych skrzypiec #@violins_free; liczba dostpnych smyczkw #@bows_free"
    end

    sleep rand(0)
    puts "#{n}:  (...gra...)"
    sleep rand(0)
    puts "#{n}: Zakoczy gr."

    @music.synchronize do
      @violins_free += 1
      @violin.signal if @violins_free == 1
      @bows_free += 1
      @bow.signal if @bows_free == 1
    end
  end
end

threads = []
3.times {|i| threads << Thread.new { musician(i) } }

threads.each {|t| t.join }
