require 'fox16'

include Fox

class TwoButtonUpdateWindow < FXMainWindow

  def initialize(app)
    # Invoke base class initialize first
    super(app, "Przykad aktualizacji", nil, nil,
          DECOR_TITLE | DECOR_CLOSE)

    # First button
    @button_one = FXButton.new(self, "Wcz przycisk nr 2")
    @button_one_enabled = true

    # Second button
    @button_two = FXButton.new(self, "Wcz przycisk nr 1")
    @button_two.disable
    @button_two_enabled = false

# Hook up the message handlers
@button_one.connect(SEL_COMMAND, method(:onCommand))
@button_two.connect(SEL_COMMAND, method(:onCommand))
@button_one.connect(SEL_UPDATE,  method(:onUpdate))
@button_two.connect(SEL_UPDATE,  method(:onUpdate))
  end

  def onCommand(sender, sel, ptr)
    # Update the application state
    @button_one_enabled = !@button_one_enabled
    @button_two_enabled = !@button_two_enabled
  end

  def onUpdate(sender, sel, ptr)
    # Update the buttons based on the application state
    @button_one_enabled ?
      @button_one.enable : @button_one.disable
    @button_two_enabled ?
      @button_two.enable : @button_two.disable
  end

end

application = FXApp.new
main = TwoButtonUpdateWindow.new(application)
application.create
main.show(PLACEMENT_SCREEN)
application.run
