$KCODE = "U"
require "gtk2"

class TextWindow < Gtk::Window

  def initialize
    super("Prosty edytor Ruby/GTK2")
    signal_connect("destroy") { Gtk.main_quit }
    set_default_size(200, 100)
    @text = Gtk::TextView.new
    @text.wrap_mode = Gtk::TextTag::WRAP_WORD

    @buffer = @text.buffer
    @buffer.signal_connect("changed") {
      @status.text = "Dugo: " + @buffer.char_count.to_s
    }

    @buffer.create_tag('notice',
                       'font' => "Times Bold Italic 18",
                       'foreground' => "red")

    @status = Gtk::Label.new

    scroller = Gtk::ScrolledWindow.new
    scroller.set_policy(Gtk::POLICY_AUTOMATIC, Gtk::POLICY_NEVER)
    scroller.add(@text)

    box = Gtk::VBox.new
    box.add(scroller)
    box.add(@status)
    add(box)

    iter = @buffer.start_iter
    @buffer.insert(iter, "To jest prosty edytor tekstu.")
    iter.offset = 8
    @buffer.insert(iter, "bardzo ", "notice")

    show_all
  end
end

Gtk.init
TextWindow.new
Gtk.main
