require 'Qt'

class MyWidget < Qt::Widget
  slots 'buttonClickedSlot()'

  def initialize(parent = nil)
    super(parent)

    setWindowTitle("Przykad QtRuby");
    @lineedit = Qt::LineEdit.new(self)
    @button = Qt::PushButton.new("Wielkie litery!",self)

    connect(@button, SIGNAL('clicked()'),
            self, SLOT('buttonClickedSlot()'))

    box = Qt::HBoxLayout.new
    box.addWidget(Qt::Label.new("Tekst:"))
    box.addWidget(@lineedit)
    box.addWidget(@button)

    setLayout(box)
  end

  def buttonClickedSlot
    @lineedit.setText(@lineedit.text.upcase)
  end

end

app = Qt::Application.new(ARGV)
widget = MyWidget.new
widget.show
app.exec
