require 'tk'

# Typowe opcje decydujce o rozmieszczeniu kontrolek...
Top  = { 'side' => 'top', 'padx'=>5, 'pady'=>5 }
Left = { 'side' => 'left', 'padx'=>5, 'pady'=>5 }
Bottom = { 'side' => 'bottom', 'padx'=>5, 'pady'=>5 }

temp = 21   # Temperatura pocztkowa...

root = TkRoot.new { title "Termostat" }

top = TkFrame.new(root) { background "#606060" }
bottom = TkFrame.new(root)

tlab = TkLabel.new(top) do
  text temp.to_s
  font "{Arial} 54 {bold}"
  foreground "green"
  background "#606060"
  pack Left
end

TkLabel.new(top) do         # symbol stopni
  text "o"
  font "{Arial} 14 {bold}"
  foreground "green"
  background "#606060"
  # Dodajemy do tablicy mieszajcej kotwic.
  pack Left.update({ 'anchor' => 'n' })
end

TkButton.new(bottom) do
  text " + "
  command proc { tlab.configure("text"=>(temp+=1).to_s) }
  pack Left
end

TkButton.new(bottom) do
  text " - "
  command proc { tlab.configure("text"=>(temp-=1).to_s) }
  pack Left
end

top.pack Top
bottom.pack Bottom

Tk.mainloop
