require 'open-uri'
require 'iconv'

def get_web_page_as_utf8(url)
  open(url) do |io|
    source = io.read
    type, *parameters = io.content_type_parse
    # Nie konwertujemy niczego poza kodem jzyka HTML lub XHTML:
    unless type =~ %r!^(?:text/html|application/xhtml+xml)$!
      return source
    end
    # W pierwszej kolejnoci weryfikujemy nagwki serwera:
    if pair = parameters.assoc('charset')
      encoding = pair.last
    # Nastpnie przetwarzamy waciwy kod HTML-a:
    elsif source =~ /\]*?charset=([^\s'"]+)/i
      encoding = $1
    # Na koniec stosujemy domylne kodowanie protokou HTTP:
    else
      encoding = 'ISO-8859-1'
    end
    converter = Iconv.new('UTF-8//IGNORE', encoding)
    return converter.iconv(source)
  end
end
