##
# Prosty skrypt upraszczajcy korzystanie z rozwizania zastpczego i odcianie
# serwera comp.lang.ruby przez wysyanie wiadomoci listy dyskusyjnej ruby-talk.
#
# Niniejszy program powinien by uruchamiany cyklicznie (np. co 20 minut).
# Jego dziaanie polega na przeszukaniu serwera grupy dyskusyjnej pod ktem
# zawierania artykuw z wyszym identyfikatorem komunikatu od identyfikatora
# ostatniego komunikatu, ktry ju wysano za porednictwem poczty elektronicznej.
# Jeli takie artykuy uda si odnale, poniszy program odczyta je, wyle
# ich zawarto na adres listy dyskusyjnej, po czym zarejestruje nowy najwyszy
# identyfikator wiadomoci.

require 'nntp'
require 'net/smtp'
require 'params'

include NNTP

##
# Wysya wiadomo poczty elektronicznej na adres listy dyskusyjnej. Nadawc
# wiadomoci musi by zarejestrowany uytkownik tej listy, mimo e wiersz Od:
# teoretycznie moe zawiera dowolny prawidowy adres poczty elektronicznej.
#

def send_mail(head, body)
  smtp = Net::SMTP.new
  smtp.start(Params::SMTP_SERVER)
  smtp.ready(Params::MAIL_SENDER, Params::MAILING_LIST) do |a|
    a.write head
    a.write "#{Params::LOOP_FLAG}\r\n"
    a.write "\r\n"
    a.write body
  end
end

##
# Rejestrujemy identyfikator wiadomoci reprezentujcej ostatni otrzymany artyku.

begin
  last_news = File.open(Params::LAST_NEWS_FILE) {|f| f.read} .to_i
rescue
  last_news = nil
end

##
# Nawizujemy poczenie z serwerem grupy dyskusyjnej i odczytujemy
# biece numery wiadomoci dla grupy comp.lang.ruby.
#
nntp = NNTPIO.new(Params::NEWS_SERVER)
raise "Prba nawizania poczenia zakoczya si niepowodzeniem." unless nntp.connect
count, first, last = nntp.set_group(Params::NEWSGROUP)

##
# Jeli do tej pory nie utrzymywalimy najwyszego identyfikatora
# wiadomoci, rejestrujemy t warto teraz.

if not last_news
  last_news = last
end

##
# Przechodzimy do ostatniego artykuu odczytanego poprzednim razem, po czym prbujemy
# odczyta ewentualne nowsze artykuy. Ta prba moe si zakoczy wygenerowaniem
# wyjtku, jeli uyty identyfikator dotyczy ju nieistniejcego artykuu. 

begin
  nntp.set_stat(last_news)
rescue
end

##
# Na koniec odczytujemy artykuy do chwili, w ktrej wyczerpiemy 
# dostpn pul, i wysyamy kady z nich na list dyskusyjn.

new_last = last_news

begin
  loop do
    nntp.set_next
    head = ""
    body = ""
    new_last, = nntp.get_head do |line|
      head << line
    end

    # Nie wysyamy artykuw, ktre zostay wysane ju przez program mail2news
    # na adres danej grupy dyskusyjnej (w przeciwnym razie wpadlibymy w ptl).
    next if head =~ %r{^X-rubymirror:}

    nntp.get_body do |line|
      body << line
    end

    send_mail(head, body)
  end
rescue
end

##
# Rejestrujemy nowe informacje o stanie.

File.open(Params::LAST_NEWS_FILE, "w") do |f|
  f.puts  new_last
end unless new_last == last_news
