# mail2news: Otrzymuje wiadomo poczty elektronicznej i przekazuje
# j w formie nowego wpisu grupy dyskusyjnej.

require "nntp"
include NNTP

require "params"

# Odczytuje wiadomo poczty elektronicznej, po czym
# wyodrbnia jej nagwki i ciao. Tylko niektre
# nagwki zostan uyte w grupie dyskusyjnej.

HEADERS = %w{From Subject References Message-ID
             Content-Type Content-Transfer-Encoding Date}

allowed_headers = Regexp.new(%{^(#{HEADERS.join("|")}):})

# Odczytuje nagwek. Uwzgldniamy tylko niektre nagwki
# oryginalnej wiadomoci. Dodaje nowy wiersz w ramach grupy
# dyskusyjnej i wiersz X-rubymirror.

head = "Grupa dyskusyjna: #{Params::NEWSGROUP}\n"
subject = "nieznany"
while line = gets
  exit if line =~ /^#{Params::LOOP_FLAG}/o # to nie powinno si zdarzy
  break if line =~ /^\s*$/
  next if line =~ /^\s/
  next unless line =~ allowed_headers

  # Usuwa z tematu przedrostek [ruby-talk:nnnn] przed jego
  # przekazaniem do grupy dyskusyjnej.
  if line =~ /^Subject:\s*(.*)/
    subject = $1

    # Poniszy fragment usuwa specjalny numer ruby-talk
    # z pocztku wiadomoci listy dyskusyjnej przed ich
    # przekazaniem na serwer grupy dyskusyjnej.

    line.sub!(/\[ruby-talk:(\d+)\]\s*/, '')
    subject = "[#$1] #{line}"
    head << "X-ruby-talk: #$1\n"
  end
  head << line
end

head << "#{Params::LOOP_FLAG}\n"


body = ""
while line = gets
  body << line
end

msg = head + "\n" + body
msg.gsub!(/\r?\n/, "\r\n")

nntp = NNTPIO.new(Params::NEWS_SERVER)
raise "Prba nawizania poczenia zakoczya si niepowodzeniem." unless nntp.connect
nntp.post(msg)
