require 'RMagick'

img = Magick::ImageList.new("vw.jpg")

# Kada z tych metod moe otrzymywa na wejciu zarwno pojedynczy parametr
# wspczynnika, jak i par liczb cakowitych reprezentujcych szeroko i wysoko.

# Metoda thumbnail jest zdecydowanie najszybsza (szczeglnie jeli redukuje obraz do bardzo maego rozmiaru).

pic1 = img.thumbnail(0.2)      # Redukcja do 20% oryginalnych wymiarw.
pic2 = img.thumbnail(64,48)    # Redukcja do wymiarw 64x48 pikseli.

# Metoda resize charakteryzuje si przecitn wydajnoci. Jeli zdefiniujemy trzeci
# i (lub) czwarty parametr, okrelimy odpowiednio filtr i wspczynnik rozmazania.
# Domyln wartoci parametru filtra jest LanczosFilter natomiast domylny wspczynnik
# rozmazania wynosi 1.0.

pic3 = img.resize(0.40)        # Redukcja do 40% oryginalnych wymiarw.
pic4 = img.resize(320,240)     # Redukcja do wymiarw 320x240 pikseli.
pic5 = img.resize(300,200,Magick::LanczosFilter,0.92)

# Take metoda sample charakteryzuje si przecitn wydajnoci (poniewa nie dokonuje interpolacji kolorw).

pic6 = img.sample(0.35)        # Redukcja do 35% oryginalnych wymiarw.
pic7 = img.sample(320,240)     # Redukcja do wymiarw 320x240 pikseli.

# Moje testy wykazay, e metoda scale jest zdecydowanie najwolniejsza.

pic8 = img.scale(0.60)         # Redukcja do 60% oryginalnych wymiarw.
pic9 = img.scale(400,300)      # Redukcja do wymiarw 400x300 pikseli.
