require 'rexml/document'
include REXML

input = File.new("books.xml")
doc = Document.new(input)

root = doc.root
puts root.attributes["shelf"]      # Ostatnie nabytki

doc.elements.each("library/section") { |e| puts e.attributes["name"] }
# Dane wyjciowe:
#   Ruby
#   Space

doc.elements.each("*/section/book") { |e| puts e.attributes["isbn"] }
# Dane wyjciowe:
#   0672328844
#   0321445619
#   0684835509
#   074325631X

sec2 = root.elements[2]
author = sec2.elements[1].elements["author"].text       # Robert Zubrin
