def quadrant(pdf, quad)
  raise unless block_given?

  mx = pdf.absolute_x_middle
  my = pdf.absolute_y_middle

  pdf.save_state

  case quad
  when :ul
    pdf.translate_axis(0, my)
  when :ur
    pdf.translate_axis(mx, my)
  when :ll
    nil # pdf.translate_axis(0, 0)
  when :lr
    pdf.translate_axis(mx, 0)
  end

  pdf.scale_axis(0.5, 0.5)
  pdf.y = pdf.page_height
  yield
  pdf.restore_state
end
