$KCODE = "U"
require "gtk2"

class TicketWindow < Gtk::Window

  def initialize
    super("System rezerwacji")
    signal_connect("destroy") { Gtk.main_quit }

    dest_model = Gtk::ListStore.new(String, String)
    dest_view = Gtk::TreeView.new(dest_model)
    dest_column = Gtk::TreeViewColumn.new("Cel lotu",
                      Gtk::CellRendererText.new,
                      :text => 0)
    dest_view.append_column(dest_column)
    country_column = Gtk::TreeViewColumn.new("Kraj",
                         Gtk::CellRendererText.new,
                         :text => 1)
    dest_view.append_column(country_column)
    dest_view.selection.set_mode(Gtk::SELECTION_SINGLE)

    [["Kair", "Egipt"], ["Nowy Jork", "USA"],
     ["Tokio", "Japonia"]].each do |destination, country|
      iter = dest_model.append
      iter[0] = destination
      iter[1] = country
    end
    dest_view.selection.signal_connect("changed") do
      @city = dest_view.selection.selected[0]
    end

    @round_trip = Gtk::CheckButton.new("W obie strony")

    purchase = Gtk::Button.new("Dokonaj rezerwacji")
    purchase.signal_connect("clicked") { cmd_purchase }

    @result = Gtk::Label.new

    @coach = Gtk::RadioButton.new("Klasa ekonomiczna")
    @business = Gtk::RadioButton.new(@coach, "Klasa biznes")
    @first = Gtk::RadioButton.new(@coach, "Pierwsza klasa")

    flight_box = Gtk::VBox.new
    flight_box.add(dest_view).add(@round_trip)

    seat_box = Gtk::VBox.new
    seat_box.add(@coach).add(@business).add(@first)

    top_box = Gtk::HBox.new
    top_box.add(flight_box).add(seat_box)

    main_box = Gtk::VBox.new
    main_box.add(top_box).add(purchase).add(@result)

    add(main_box)
    show_all
  end

  def cmd_purchase
    text = @city
    if @first.active?
      text += ": pierwsza klasa"
    elsif @business.active?
      text += ": klasa biznes"
    elsif @coach.active?
      text += ": klasa ekonomiczna"
    end
    text += ", w obie strony " if @round_trip.active?
    @result.text = text
  end

end

Gtk.init
TicketWindow.new
Gtk.main
