class LowerMatrix < TriMatrix

  def initialize
    @store = ZArray.new
  end

end


class Graph

  def initialize(*edges)
    @store = LowerMatrix.new
    @max = 0
    for e in edges
      e[0], e[1] = e[1], e[0] if e[1] > e[0]
      @store[e[0],e[1]] = 1
      @max = [@max, e[0], e[1]].max
    end
  end

  def [](x,y)
    if x > y
      @store[x,y]
    elsif x < y
      @store[y,x]
    else
      0
    end
  end

  def []=(x,y,v)
    if x > y
      @store[x,y]=v
    elsif x < y
      @store[y,x]=v
    else
      0
    end
  end

  def edge? x,y
    x,y = y,x if x < y
    @store[x,y]==1
  end

  def add x,y
    @store[x,y] = 1
  end

  def remove x,y
    x,y = y,x if x < y
    @store[x,y] = 0
    if (degree @max) == 0
      @max -= 1
    end
  end

  def vmax
    @max
  end

  def degree x
    sum = 0
    0.upto @max do |i|
      sum += self[x,i]
    end
    sum
  end

  def each_vertex
    (0..@max).each {|v| yield v}
  end

  def each_edge
    for v0 in 0..@max
      for v1 in 0..v0-1
        yield v0,v1 if self[v0,v1]==1
      end
    end
  end

end


mygraph = Graph.new([1,0],[0,3],[2,1],[3,1],[3,2])

# Wywietla stopie kadego z wierzchokw (wzw) grafu: 2 3 2 3
mygraph.each_vertex {|v| puts mygraph.degree(v)}

# Wywietla list krawdzi:
mygraph.each_edge do |a,b|
  puts "(#{a},#{b})"
end

# Usuwa pojedyncz krawd:
mygraph.remove 1,3

# Wywietla stopie kadego z wierzchokw (wzw) grafu: 2 2 2 2
mygraph.each_vertex {|v| p mygraph.degree v}
