class String

  def levenshtein(other, ins=2, del=2, sub=1)
    # Stosujemy waone koszty operacji ins, del oraz sub.
    return nil if self.nil?
    return nil if other.nil?
    dm = []        # macierz odlegoci

    # Inicjalizujemy wartoci skadowane w pierwszym wierszu.
    dm[0] = (0..self.length).collect { |i| i * ins }
    fill = [0] * (self.length - 1)

    # Inicjalizuje wartoci skadowane w pierwszej kolumnie.
    for i in 1..other.length
      dm[i] = [i * del, fill.flatten]
    end

    # Wypeniamy macierz.
    for i in 1..other.length
      for j in 1..self.length
    # Poniej zdefiniowano kluczowe porwnanie dla caej procedury:
        dm[i][j] = [
             dm[i-1][j-1] +
               (self[j-1] == other[i-1] ? 0 : sub),
                 dm[i][j-1] + ins,
             dm[i-1][j] + del
       ].min
      end
    end

    # Ostatnia warto naszej macierzy reprezentuje
    # odlego Levenshteina dzielc dwa acuchy.
    dm[other.length][self.length]
  end

end


s1 = "ACUGAUGUGA"
s2 = "AUGGAA"
d1 = s1.levenshtein(s2)    # 9


s3 = "pennsylvania"
s4 = "pencilvaneya"
d2 = s3.levenshtein(s4)    # 7


s5 = "abcd"
s6 = "abcd"
d3 = s5.levenshtein(s6)    # 0
