#include <iostream>
#include <string>
#include <sstream>
#include "gtest/gtest.h"
using namespace std;

struct Renderer
{
  virtual string what_to_render_as() const = 0;
};

struct Shape
{
  string name;
  const Renderer& renderer;

  Shape(const Renderer& renderer): renderer{renderer} {
  }

  string str() const
  {
    ostringstream oss;
    oss << "Rysuje " << name << " w postaci "
      << renderer.what_to_render_as();
    return oss.str();
  }
};

struct Triangle : Shape
{
  explicit Triangle(const Renderer& renderer)
    : Shape{renderer}
  {
    name = "trjkt";
  }
};

struct Square : Shape
{
  explicit Square(const Renderer& renderer)
    : Shape{renderer}
  {
    name = "kwadrat";
  }
};

struct RasterRenderer : Renderer
{
  string what_to_render_as() const override
  {
    return "pikseli";
  }
};

struct VectorRenderer : Renderer
{
  string what_to_render_as() const override
  {
    return "linii";
  }
};

//#include "gtest/gtest.h"

//#include "helpers/iohelper.h"

//#include "exercise.cpp"

namespace
{
  class Evaluate : public testing::Test
  {
  };

  TEST_F(Evaluate, SimpleTest)
  {
	  ASSERT_EQ("Rysuje kwadrat w postaci linii",
		  Square{ VectorRenderer{} }.str());
  }

} // namespace