using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using TMPro;
using UnityEngine.UI;
using UnityEngine.SceneManagement;
using CustomExtensions;
using System.Linq;

public class GameBehavior : MonoBehaviour, IManager
{
    public int MaxItems = 4;

    public TMP_Text HealthText;
    public TMP_Text ItemText;
    public TMP_Text ProgressText;

    public Button WinButton;
    public Button LossButton;
    private int _itemsCollected = 0;
    public Stack<Loot> LootStack = new Stack<Loot>();


    void Start()
    {
        ItemText.text += _itemsCollected;
        HealthText.text += _playerHP;
        Initialize();
    }
    public void UpdateScene(string updatedText)
    {
        ProgressText.text = updatedText;
        Time.timeScale = 0f;
    }


    public int Items
    {
        get { return _itemsCollected; }
        set
        {
            _itemsCollected = value;
            ItemText.text = "Przedmioty: " + Items;

            if (_itemsCollected >= MaxItems)
            {
                ProgressText.text = "You've found all the items!";
                WinButton.gameObject.SetActive(true);
                UpdateScene("Znalaze wszystkie przedmioty!");
            }
            else
            {
                ProgressText.text = "Przedmiot znaleziony. Jeszcze " + (MaxItems - _itemsCollected) +" do koca!";
            }
        }
    }

    private int _playerHP = 10;
    public int HP
    {
        get { return _playerHP; }
        set
        {
            _playerHP = value;
            HealthText.text = "Kondycja:" + HP;
            // 2
            if (_playerHP <= 0)
            {
                LossButton.gameObject.SetActive(true);
                UpdateScene("Czy potrzebujesz kolejnego ycia?");
            }
            else
            {
                ProgressText.text = "Ojej ... To boli.";
            }
        }
    }

    private string _state;

    // 3
    public string State
    {
        get { return _state; }
        set { _state = value; }
    }


    public void RestartScene()
    {
        Utilities.RestartLevel(0);
    }

    public void Initialize()
    {
        _state = "Meneder zainicjowany...";
        _state.FancyDebug();
        Debug.Log(_state);

        LootStack.Push(new Loot("Miecz losu ", 5));
        LootStack.Push(new Loot("Dodatkowe ycie", 1));
        LootStack.Push(new Loot("Zoty klucz", 3));
        LootStack.Push(new Loot("Skrzydlate buty ", 2));
        LootStack.Push(new Loot("Magiczne szelki", 4));

        FilterLoot();
    }


    // 3
    public void PrintLootReport()
    {
        // 1
        var currentItem = LootStack.Pop();

        // 2
        var nextItem = LootStack.Peek();

        // 3
        Debug.LogFormat("Zebrae {0}! Teraz masz szans na znalezienie {1}!", currentItem.name, nextItem.name);
        Debug.LogFormat("Na stosie oczekuje na Ciebie {0} losowych przedmiotw!", LootStack.Count);
    }

    public void FilterLoot()
    {
        var rareLoot = (from item in LootStack
                        where item.rarity >= 3
                        orderby item.rarity
                        select new { item.name })
                   .Skip(1);

        foreach (var item in rareLoot)
        {
            Debug.LogFormat("Rzadki okaz: {0}!", item.name);
        }
    }


    public bool LootPredicate(Loot loot)
    {
        return loot.rarity >= 3;
    }


}