using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.AI;
using static UnityEditor.FilePathAttribute;


public class EnemyBehavior : MonoBehaviour
{
    public Transform Player;
    public Transform PatrolRoute;
    public List<Transform> Locations;
    private int _locationIndex = 0;
    private NavMeshAgent _agent;
    private int _lives = 3;

    public int EnemyLives
    {
        // 2
        get { return _lives; }
        // 3
        private set
        {
            _lives = value;
            // 4
            if (_lives <= 0)
            {
                Destroy(this.gameObject);
                Debug.Log("Nieprzyjaciel zniszczony.");
            }
        }
    }


    void Start()
    {
        _agent = GetComponent<NavMeshAgent>();
        Player = GameObject.Find("Player").transform;
        InitializePatrolRoute();
        MoveToNextPatrolLocation();
    }



    void Update()
    {
        // 1
        if (_agent.remainingDistance < 0.2f && !_agent.pathPending)
        {
            // 2
            MoveToNextPatrolLocation();
        }
    }

    void MoveToNextPatrolLocation()
    {
        // 3
        if (Locations.Count == 0)
            return;
        _agent.destination = Locations[_locationIndex].position;
        // 4
        _locationIndex = (_locationIndex + 1) % Locations.Count;
    }


    // 4
    void InitializePatrolRoute()
    {
        // 5
        foreach (Transform child in PatrolRoute)
        {
            // 6
            Locations.Add(child);
        }
    }

    void OnTriggerEnter(Collider other)
    {
        if (other.name == "Player")
        {
            // 3
            _agent.destination = Player.position;
            Debug.Log("Wykryto nieprzyjaciela - atak!");
        }
    }

    void OnTriggerExit(Collider other)
    {
        if (other.name == "Player")
        {
            Debug.Log("Gracz poza zasigiem, wznowienie patrolu");
        }
    }

    void OnCollisionEnter(Collision collision)
    {
        // 5
        if (collision.gameObject.name == "Bullet(Clone)")
        {
            // 6
            EnemyLives -= 1;
            Debug.Log("miertelne trafienie!");
        }
    }

}