import java.util.*;

/** Tablica mieszajca z mieszaniem acuchowym.
*   @author Koffman and Wolfgang
* */

public class HashtableChain < K, V >
    implements KWHashMap < K, V > {
  /** Tablica. */
  private LinkedList < Entry < K, V >> [] table;

  /** Liczba kluczy. */
  private int numKeys;

  /** Pojemno. */
  private static final int CAPACITY = 101;

  /** Maksymalny wspczynnik wypenienia. */
  private static final double LOAD_THRESHOLD = 3.0;

  /** Zawiera pary klucz-warto dla tablicy mieszajcej. */
  private static class Entry < K, V > {

    /** Klucz. */
    private K key;

    /** Warto. */
    private V value;

    /** Tworzy now par nazwa-klucz.
        @param key Klucz.
        @param value Warto.
     */
    public Entry(K key, V value) {
      this.key = key;
      this.value = value;
    }

    /** Pobiera klucz.
        @return Klucz.
     */
    public K getKey() {
      return key;
    }

    /** Pobiera warto.
        @return Warto.
     */
    public V getValue() {
      return value;
    }

    /** Ustawia warto.
        @param val Nowa warto.
        @return Stara warto.
     */
    public V setValue(V val) {
      V oldVal = value;
      value = val;
      return oldVal;
    }
  }

  // konstruktor
  public HashtableChain() {
    table = new LinkedList[CAPACITY];
  }

  /** Metoda get() klasy HashtableChain.
      @param key Poszukiwany klucz.
      @return Jeli klucz odnaleziono, zwizana z nim warto.
              W przeciwnym razie warto null.
   */
  public V get(Object key) {
    int index = key.hashCode() % table.length;
    if (index < 0)
      index += table.length;
    if (table[index] == null)
      return null; // Klucza nie ma w tablicy.

    // Przeszukaj list wskazywan przez table[index] pod ktem klucza.
    for (Entry < K, V > nextItem : table[index]) {
      if (nextItem.key.equals(key))
        return nextItem.value;
    }

    // asercja: Klucza nie ma w tablicy.
    return null;
  }

  /** Metoda put() klasy HashtableChain.
      koc: Para klucz-warto jest wstawiona do tabeli a warto
            numKeys zinkrementowana. Jeli klucz znajduje si w tablicy
            jego warto zostaje zmieniona zgodnie z przekazanym argumentem
            Warto numKeys nie ulega wtedy zmianie. Gdy przekroczono prg
            LOAD_THRESHOLD, dochodzi do rozszerzenia tablicy.
      @param key Klucz wstawianego elementu.
      @param value Warto dla klucza.
      @return Jeli klucz istnia, jego star warto. Jeli nie istnia, warto null.
   */
  public V put(K key, V value) {
    int index = key.hashCode() % table.length;
    if (index < 0)
      index += table.length;
    if (table[index] == null) {
      // W miejscu table[index] wstaw now list.
      table[index] = new LinkedList < Entry < K, V >> ();
    }

    // Przeszukaj list spod table[index] w celu znalezienia klucza.
    for (Entry < K, V > nextItem : table[index]) {
      // Jeli odnaleziono klucz, zastp star warto.
      if (nextItem.key.equals(key)) {
        // Zastp star warto now przekazan jako parametr.
        V oldVal = nextItem.value;
        nextItem.setValue(value);
        return oldVal;
      }
    }

    // asercja: Klucza nie ma w tablicy, dodaj nowy.
    table[index].addFirst(new Entry < K, V > (key, value));
    numKeys++;
    if (numKeys > (LOAD_THRESHOLD * table.length))
      rehash();
    return null;
  }

  /** Zwraca liczb wpisw. */
  public int size() {
    return numKeys;
  }

  /** Zwraca true, jeli nie ma adnych kluczy. */
  public boolean isEmpty() {
    return numKeys == 0;
  }

/**** WICZENIE ****/
}
