import java.util.*;

/** Tablica mieszajca z otwart adresacj przechowujca elementy zbioru.
*   @author Koffman and Wolfgang
* */

public class HashSetOpen {
  private KWHashMap<K, V> setMap = new HashtableOpen<K, V>();

  /** Metoda adapterowa contains().
      @return Zwraca warto true, jeli klucz znajduje si w setMap.
   */
  public boolean contains(Object key) {
    // HashtableOpen.get() zwraca null, jeli klucza nie odnaleziono.
    return (setMap.get(key) != null);
  }

  /** Metoda adapterowa add().
      koc: Dodaje nowy obiekt Entry (key, key), jeli key nie jest duplikatem.
      @return Zwraca warto true, jeli klucz nie jest duplikatem.
   */
  public boolean add(K key) {
    /* HashtableOpen.put() zwraca null, jeli key nie duplikatem. */
    return (setMap.put(key, key) == null);
  }

  /** Metoda adapterowa remove().
      koc: Usuwa par klucz-warto (key, key).
      @return Zwraca warto true,jeli klucz odnaleziono i usunito.
   */
  public boolean remove(Object key) {
    /* HashtableOpen.remove() zwraca null, jeli klucza nie usunito. */
    return (setMap.remove() != null);
  }
}
